/// <reference path="./internal_*.d.ts" />
declare namespace com.simibubi.create.content.equipment.wrench {
    class WrenchItem extends Internal.Item {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        static wrenchInstaKillsMinecarts(player: Internal.Player_, world: Internal.Level_, hand: Internal.InteractionHand_, target: Internal.Entity_, entityRayTraceResult: Internal.EntityHitResult_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type WrenchItem_ = WrenchItem;
}
declare namespace Internal {
    interface Control {
    }
    type Control_ = Control;
    interface FabricDataGenerator$Pack$RegistryDependentFactory <T extends Internal.DataProvider> {
        abstract create(arg0: Internal.FabricDataOutput_, arg1: Internal.CompletableFuture_<Internal.HolderLookup$Provider>): T;
        (arg0: Internal.FabricDataOutput, arg1: Internal.CompletableFuture<Internal.HolderLookup$Provider>): T;
    }
    type FabricDataGenerator$Pack$RegistryDependentFactory_<T extends Internal.DataProvider> = FabricDataGenerator$Pack$RegistryDependentFactory<T>;
    class NoMilkEffect extends Internal.TinkerEffect {
        constructor(typeIn: Internal.MobEffectCategory_, color: number, show: boolean)
        getSortOrder(potionEffect: Internal.MobEffectInstance_): number;
    }
    type NoMilkEffect_ = NoMilkEffect;
    class StringyCobwebFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        canPlace(world: Internal.WorldGenLevel_, pos: BlockPos_, length: number, dir: Internal.Direction_): boolean;
        placeCobweb(world: Internal.WorldGenLevel_, pos: BlockPos_, length: number, dir: Internal.Direction_): void;
    }
    type StringyCobwebFeature_ = StringyCobwebFeature;
    interface LocationAwareLogger extends Internal.Logger {
        abstract trace(arg0: string, ...arg1: any[]): void;
        abstract error(arg0: string): void;
        abstract warn(arg0: string, arg1: any, arg2: any): void;
        abstract isTraceEnabled(arg0: org.slf4j.Marker_): boolean;
        abstract info(arg0: string, arg1: Internal.Throwable_): void;
        abstract debug(arg0: string): void;
        abstract warn(arg0: org.slf4j.Marker_, arg1: string, arg2: any, arg3: any): void;
        abstract error(arg0: org.slf4j.Marker_, arg1: string): void;
        abstract trace(arg0: org.slf4j.Marker_, arg1: string, arg2: any): void;
        abstract error(arg0: string, ...arg1: any[]): void;
        abstract warn(arg0: string, arg1: any): void;
        abstract trace(arg0: org.slf4j.Marker_, arg1: string): void;
        abstract warn(arg0: org.slf4j.Marker_, arg1: string, ...arg2: any[]): void;
        abstract info(arg0: string): void;
        atTrace(): Internal.LoggingEventBuilder;
        isEnabledForLevel(arg0: org.slf4j.event.Level_): boolean;
        abstract debug(arg0: string, ...arg1: any[]): void;
        abstract debug(arg0: org.slf4j.Marker_, arg1: string): void;
        abstract info(arg0: org.slf4j.Marker_, arg1: string, ...arg2: any[]): void;
        abstract warn(arg0: org.slf4j.Marker_, arg1: string, arg2: Internal.Throwable_): void;
        abstract warn(arg0: string, arg1: Internal.Throwable_): void;
        atDebug(): Internal.LoggingEventBuilder;
        abstract info(arg0: string, arg1: any): void;
        abstract error(arg0: org.slf4j.Marker_, arg1: string, arg2: any): void;
        abstract isTraceEnabled(): boolean;
        abstract isWarnEnabled(arg0: org.slf4j.Marker_): boolean;
        abstract log(arg0: org.slf4j.Marker_, arg1: string, arg2: number, arg3: string, arg4: any[], arg5: Internal.Throwable_): void;
        abstract trace(arg0: string): void;
        abstract info(arg0: org.slf4j.Marker_, arg1: string): void;
        abstract debug(arg0: string, arg1: any, arg2: any): void;
        abstract info(arg0: org.slf4j.Marker_, arg1: string, arg2: any, arg3: any): void;
        abstract debug(arg0: org.slf4j.Marker_, arg1: string, arg2: any): void;
        abstract trace(arg0: string, arg1: any): void;
        abstract error(arg0: org.slf4j.Marker_, arg1: string, arg2: any, arg3: any): void;
        abstract trace(arg0: string, arg1: any, arg2: any): void;
        abstract debug(arg0: org.slf4j.Marker_, arg1: string, arg2: any, arg3: any): void;
        abstract isDebugEnabled(): boolean;
        atWarn(): Internal.LoggingEventBuilder;
        makeLoggingEventBuilder(arg0: org.slf4j.event.Level_): Internal.LoggingEventBuilder;
        abstract trace(arg0: org.slf4j.Marker_, arg1: string, arg2: any, arg3: any): void;
        abstract error(arg0: string, arg1: any): void;
        abstract info(arg0: org.slf4j.Marker_, arg1: string, arg2: Internal.Throwable_): void;
        abstract warn(arg0: string): void;
        abstract warn(arg0: string, ...arg1: any[]): void;
        abstract debug(arg0: org.slf4j.Marker_, arg1: string, arg2: Internal.Throwable_): void;
        abstract trace(arg0: org.slf4j.Marker_, arg1: string, ...arg2: any[]): void;
        abstract isErrorEnabled(): boolean;
        abstract warn(arg0: org.slf4j.Marker_, arg1: string): void;
        abstract warn(arg0: org.slf4j.Marker_, arg1: string, arg2: any): void;
        abstract isWarnEnabled(): boolean;
        abstract error(arg0: org.slf4j.Marker_, arg1: string, arg2: Internal.Throwable_): void;
        abstract error(arg0: string, arg1: any, arg2: any): void;
        abstract getName(): string;
        abstract trace(arg0: org.slf4j.Marker_, arg1: string, arg2: Internal.Throwable_): void;
        abstract debug(arg0: string, arg1: any): void;
        abstract isErrorEnabled(arg0: org.slf4j.Marker_): boolean;
        abstract info(arg0: org.slf4j.Marker_, arg1: string, arg2: any): void;
        abstract info(arg0: string, arg1: any, arg2: any): void;
        abstract isInfoEnabled(): boolean;
        atInfo(): Internal.LoggingEventBuilder;
        atError(): Internal.LoggingEventBuilder;
        abstract debug(arg0: string, arg1: Internal.Throwable_): void;
        abstract info(arg0: string, ...arg1: any[]): void;
        abstract error(arg0: org.slf4j.Marker_, arg1: string, ...arg2: any[]): void;
        abstract isDebugEnabled(arg0: org.slf4j.Marker_): boolean;
        abstract isInfoEnabled(arg0: org.slf4j.Marker_): boolean;
        abstract debug(arg0: org.slf4j.Marker_, arg1: string, ...arg2: any[]): void;
        abstract trace(arg0: string, arg1: Internal.Throwable_): void;
        abstract error(arg0: string, arg1: Internal.Throwable_): void;
        atLevel(arg0: org.slf4j.event.Level_): Internal.LoggingEventBuilder;
        get traceEnabled(): boolean
        get debugEnabled(): boolean
        get errorEnabled(): boolean
        get warnEnabled(): boolean
        get name(): string
        get infoEnabled(): boolean
        readonly INFO_INT: 20;
        readonly TRACE_INT: 0;
        readonly DEBUG_INT: 10;
        readonly ERROR_INT: 40;
        readonly WARN_INT: 30;
    }
    type LocationAwareLogger_ = LocationAwareLogger;
    interface INBTSerializableCompound extends Internal.INBTSerializable<Internal.CompoundTag> {
        deserializeNBT(nbt: Internal.CompoundTag_): void;
        serializeNBT(): Internal.CompoundTag;
    }
    type INBTSerializableCompound_ = INBTSerializableCompound;
    interface StructureProcessorExtensions {
        processEntity(world: Internal.LevelReader_, seedPos: BlockPos_, rawEntityInfo: Internal.StructureTemplate$StructureEntityInfo_, entityInfo: Internal.StructureTemplate$StructureEntityInfo_, placementSettings: Internal.StructurePlaceSettings_, template: Internal.StructureTemplate_): Internal.StructureTemplate$StructureEntityInfo;
    }
    type StructureProcessorExtensions_ = StructureProcessorExtensions;
    interface ParticleRenderType {
        abstract begin(arg0: Internal.BufferBuilder_, arg1: Internal.TextureManager_): void;
        abstract end(arg0: Internal.Tesselator_): void;
        readonly TERRAIN_SHEET: Internal.ParticleRenderType;
        readonly CUSTOM: Internal.ParticleRenderType;
        readonly PARTICLE_SHEET_OPAQUE: Internal.ParticleRenderType;
        readonly PARTICLE_SHEET_LIT: Internal.ParticleRenderType;
        readonly NO_RENDER: Internal.ParticleRenderType;
        readonly PARTICLE_SHEET_TRANSLUCENT: Internal.ParticleRenderType;
    }
    type ParticleRenderType_ = ParticleRenderType;
    class FrogspawnBlock extends Internal.Block {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        static setDefaultHatchDelay(): void;
        emi(): Internal.EmiStack;
        static setHatchDelay($$0: number, $$1: number): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type FrogspawnBlock_ = FrogspawnBlock;
    class SparseDuneGrassFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type SparseDuneGrassFeature_ = SparseDuneGrassFeature;
    class ThresholdSwitchBlock extends Internal.DirectedDirectionalBlock implements Internal.ConnectableRedstoneBlock, Internal.IBE<Internal.ThresholdSwitchBlockEntity> {
        constructor(p_i48377_1_: Internal.BlockBehaviour$Properties_)
        getBlockEntityClass(): typeof Internal.ThresholdSwitchBlockEntity;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ThresholdSwitchBlockEntity;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ThresholdSwitchBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockEntityType(): Internal.BlockEntityType<Internal.ThresholdSwitchBlockEntity>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ThresholdSwitchBlockEntity>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        canConnectRedstone(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, side: Internal.Direction_): boolean;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ThresholdSwitchBlockEntity>): void;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityClass(): typeof Internal.ThresholdSwitchBlockEntity
        get blockEntityType(): Internal.BlockEntityType<Internal.ThresholdSwitchBlockEntity>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly LEVEL: Internal.IntegerProperty;
    }
    type ThresholdSwitchBlock_ = ThresholdSwitchBlock;
    class WildCropFeature extends Internal.Feature<any> {
        constructor(codec: Internal.Codec_<any>)
    }
    type WildCropFeature_ = WildCropFeature;
    class Brain$Provider <E extends Internal.LivingEntity> {
        makeBrain($$0: Internal.Dynamic_<any>): Internal.Brain<E>;
    }
    type Brain$Provider_<E extends Internal.LivingEntity> = Brain$Provider<E>;
    class Tooltip implements Internal.NarrationSupplier, Internal.TooltipAccessor {
        constructor($$0: net.minecraft.network.chat.Component_, $$1: net.minecraft.network.chat.Component_)
        toCharSequence($$0: Internal.Minecraft_): Internal.List<Internal.FormattedCharSequence>;
        static splitTooltip($$0: Internal.Minecraft_, $$1: net.minecraft.network.chat.Component_): Internal.List<Internal.FormattedCharSequence>;
        updateNarration($$0: Internal.NarrationElementOutput_): void;
        setCachedTooltip(arg0: Internal.List_<any>): void;
        static create($$0: net.minecraft.network.chat.Component_, $$1: net.minecraft.network.chat.Component_): Internal.Tooltip;
        static create($$0: net.minecraft.network.chat.Component_): Internal.Tooltip;
        set cachedTooltip(arg0: Internal.List_<any>)
    }
    type Tooltip_ = Tooltip;
    class ClientboundInitializeBorderPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.WorldBorder_)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        getLerpTime(): number;
        getOldSize(): number;
        write($$0: Internal.FriendlyByteBuf_): void;
        getWarningBlocks(): number;
        getNewSize(): number;
        getNewCenterX(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getNewCenterZ(): number;
        getWarningTime(): number;
        getNewAbsoluteMaxSize(): number;
        isSkippable(): boolean;
        get lerpTime(): number
        get oldSize(): number
        get warningBlocks(): number
        get newSize(): number
        get newCenterX(): number
        get newCenterZ(): number
        get warningTime(): number
        get newAbsoluteMaxSize(): number
        get skippable(): boolean
    }
    type ClientboundInitializeBorderPacket_ = ClientboundInitializeBorderPacket;
    abstract class ConfigFromString <T> extends Internal.ConfigValue<T> {
        constructor()
        canScroll(): boolean;
        abstract parse(arg0: Internal.Consumer_<T>, arg1: string): boolean;
        scrollValue(currentValue: T, forward: boolean): Internal.Optional<T>;
        getStringFromValue(v: T): string;
    }
    type ConfigFromString_<T> = ConfigFromString<T>;
    interface BlockEntityEventCallback {
        abstract accept(arg0: Internal.BlockEntityJS_, arg1: number): void;
        (arg0: Internal.BlockEntityJS, arg1: number): void;
    }
    type BlockEntityEventCallback_ = BlockEntityEventCallback;
    class LootDataManager implements Internal.LootManagerConditionManager, Internal.LootDataResolver, Internal.PreparableReloadListener, Internal.LootTablesKJS, Internal.IdentifiableResourceReloadListener {
        constructor()
        getLootTable($$0: ResourceLocation_): Internal.LootTable;
        getElement<T>($$0: Internal.LootDataType_<T>, $$1: ResourceLocation_): T;
        getKeys($$0: Internal.LootDataType_<any>): Internal.Collection<ResourceLocation>;
        getKeysToValues(): Internal.Map<any, any>;
        static kjs$postLootEvents(map: Internal.Map_<ResourceLocation, Internal.JsonElement>): void;
        getElementOptional<T>($$0: Internal.LootDataType_<T>, $$1: ResourceLocation_): Internal.Optional<T>;
        getElement<T>($$0: Internal.LootDataId_<T>): T;
        getFabricDependencies(): Internal.Collection<any>;
        handler$gik000$probejs$apply(parsedMap: Internal.Map_<any, any>, ci: Internal.CallbackInfo_): void;
        static createComposite($$0: Internal.LootItemCondition_[]): Internal.LootItemCondition;
        getName(): string;
        getElementOptional<T>($$0: Internal.LootDataId_<T>): Internal.Optional<T>;
        kjs$completeReload(parsedMap: Internal.Map_<Internal.LootDataType<any>, Internal.Map<ResourceLocation, any>>, elements: Internal.Map_<Internal.LootDataId<any>, any>): void;
        getFabricId(): ResourceLocation;
        static createComposite($$0: Internal.LootItemFunction_[]): Internal.LootItemFunction;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        get keysToValues(): Internal.Map<any, any>
        get fabricDependencies(): Internal.Collection<any>
        get name(): string
        get fabricId(): ResourceLocation
        static readonly EMPTY_LOOT_TABLE_KEY: Internal.LootDataId<Internal.LootTable>;
    }
    type LootDataManager_ = LootDataManager;
    class BoatItem extends Internal.Item {
        constructor($$0: boolean, $$1: Internal.Boat$Type_, $$2: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BoatItem_ = BoatItem;
    interface IHarvestLogic extends Internal.GenericLoaderRegistry$IHaveLoader<Internal.IHarvestLogic> {
        getDestroySpeed(tool: Internal.IToolStackView_, state: Internal.BlockState_): number;
        abstract isEffective(arg0: Internal.IToolStackView_, arg1: Internal.BlockState_): boolean;
        abstract getLoader(): Internal.GenericLoaderRegistry$IGenericLoader<Internal.IHarvestLogic>;
        getTier(tool: Internal.IToolStackView_): Internal.Tier;
        get loader(): Internal.GenericLoaderRegistry$IGenericLoader<Internal.IHarvestLogic>
        readonly DEFAULT: Internal.IHarvestLogic;
        readonly LOADER: Internal.GenericLoaderRegistry<Internal.IHarvestLogic>;
    }
    type IHarvestLogic_ = IHarvestLogic;
    interface EntityEvents$ProjectileImpact {
        abstract onProjectileImpact(arg0: Internal.ProjectileImpactEvent_): void;
        (arg0: Internal.ProjectileImpactEvent): void;
    }
    type EntityEvents$ProjectileImpact_ = EntityEvents$ProjectileImpact;
    class ArrayOrSelf <T> {
    }
    type ArrayOrSelf_<T> = T | T[];
    class IntegerProperty extends Internal.Property<number> {
        getName($$0: number): string;
        getPossibleValues(): Internal.Collection<number>;
        static create($$0: string, $$1: number, $$2: number): Internal.IntegerProperty;
        getValue($$0: string): Internal.Optional<number>;
        get possibleValues(): Internal.Collection<number>
    }
    type IntegerProperty_ = IntegerProperty;
    interface NonNullBiConsumer <T, U> extends Internal.BiConsumer<T, U> {
        abstract accept(arg0: T, arg1: U): void;
        noop<T, U>(): this;
        andThen(arg0: Internal.BiConsumer_<T, U>): Internal.BiConsumer<T, U>;
        (arg0: T, arg1: U): void;
    }
    type NonNullBiConsumer_<T, U> = NonNullBiConsumer<T, U>;
    interface Closeable extends Internal.AutoCloseable {
        abstract close(): void;
        (): void;
    }
    type Closeable_ = Closeable;
    class CodecRecipeSerializer <R extends Internal.Recipe<any>> implements Internal.RecipeSerializer<R> {
        constructor(recipeType: Internal.RecipeType_<R>, codec: Internal.Function_<ResourceLocation, Internal.Codec<R>>)
        constructor(recipeType: Internal.RecipeType_<R>, jsonCodec: Internal.Function_<ResourceLocation, Internal.Codec<R>>, networkCodec: Internal.Function_<ResourceLocation, Internal.Codec<R>>)
        fromJson(id: ResourceLocation_, json: Internal.JsonObject_): R;
        fromNetwork(id: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): R;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        toNetwork(buffer: Internal.FriendlyByteBuf_, recipe: R): void;
        type(): Internal.RecipeType<R>;
    }
    type CodecRecipeSerializer_<R extends Internal.Recipe<any>> = CodecRecipeSerializer<R>;
    class HugeBrownMushroomFeature extends Internal.AbstractHugeMushroomFeature {
        constructor($$0: Internal.Codec_<Internal.HugeMushroomFeatureConfiguration>)
    }
    type HugeBrownMushroomFeature_ = HugeBrownMushroomFeature;
    class FluidSounds {
        constructor()
        addSound(name: string, sound: Internal.SoundEvent_): void;
        getSounds(): Internal.Map<string, Internal.SoundEvent>;
        getSound(name: string): Internal.SoundEvent;
        get sounds(): Internal.Map<string, Internal.SoundEvent>
    }
    type FluidSounds_ = FluidSounds;
    interface MobEffectBuilder$EffectTickCallback {
        abstract applyEffectTick(arg0: Internal.LivingEntity_, arg1: number): void;
        (arg0: Internal.LivingEntity, arg1: number): void;
    }
    type MobEffectBuilder$EffectTickCallback_ = MobEffectBuilder$EffectTickCallback;
    class Mule extends Internal.AbstractChestedHorse {
        constructor($$0: Internal.EntityType_<Internal.Mule>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getOwner(): Internal.LivingEntity;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getSaddleSoundEvent(): Internal.SoundEvent;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getJumpCooldown(): number;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get owner(): Internal.LivingEntity
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get saddleSoundEvent(): Internal.SoundEvent
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get jumpCooldown(): number
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
    }
    type Mule_ = Mule;
    class TelemetryProperty$ServerType extends Internal.Enum<Internal.TelemetryProperty$ServerType> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        static valueOf($$0: string): Internal.TelemetryProperty$ServerType;
        getSerializedName(): string;
        static values(): Internal.TelemetryProperty$ServerType[];
        get serializedName(): string
        static readonly OTHER: Internal.TelemetryProperty$ServerType;
        static readonly CODEC: Internal.Codec<Internal.TelemetryProperty$ServerType>;
        static readonly REALM: Internal.TelemetryProperty$ServerType;
        static readonly LOCAL: Internal.TelemetryProperty$ServerType;
    }
    type TelemetryProperty$ServerType_ = "local" | "other" | "realm" | TelemetryProperty$ServerType;
    interface Layout {
        abstract elements(): Internal.List<Internal.Layout$Element>;
        abstract byteAlignment(): number;
        abstract asMap(): Internal.Map<string, Internal.Layout$Element>;
        abstract byteSize(): number;
        readonly MAX_ELEMENT_NAME_LENGTH: 896;
    }
    type Layout_ = Layout;
    class ControllerState extends Internal.Enum<Internal.ControllerState> {
        static values(): Internal.ControllerState[];
        static valueOf(name: string): Internal.ControllerState;
        static readonly CONTROLLER_CONFLICT: Internal.ControllerState;
        static readonly NO_CONTROLLER: Internal.ControllerState;
        static readonly CONTROLLER_ONLINE: Internal.ControllerState;
    }
    type ControllerState_ = "no_controller" | ControllerState | "controller_online" | "controller_conflict";
    class ScaffoldingBlock extends Internal.Block implements Internal.SimpleWaterloggedBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static getDistance($$0: Internal.BlockGetter_, $$1: BlockPos_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly STABILITY_MAX_DISTANCE: 7;
        static readonly BOTTOM: Internal.BooleanProperty;
        static readonly WATERLOGGED: Internal.BooleanProperty;
        static readonly DISTANCE: Internal.IntegerProperty;
    }
    type ScaffoldingBlock_ = ScaffoldingBlock;
    interface CustomMapData$DirtyCounter {
        abstract clearDirty(): void;
        abstract isDirty(): boolean;
        get dirty(): boolean
    }
    type CustomMapData$DirtyCounter_ = CustomMapData$DirtyCounter;
    interface IAxisPipe {
        getAxisOf(state: Internal.BlockState_): Internal.Direction$Axis;
        abstract getAxis(arg0: Internal.BlockState_): Internal.Direction$Axis;
        (arg0: Internal.BlockState): Internal.Direction$Axis_;
    }
    type IAxisPipe_ = IAxisPipe;
    class ClientboundUpdateRecipesPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: Internal.FriendlyByteBuf_)
        constructor($$0: Internal.Collection_<Internal.Recipe<any>>)
        handle(arg0: Internal.PacketListener_): void;
        static fromNetwork($$0: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        static toNetwork<T extends Internal.Recipe<any>>($$0: Internal.FriendlyByteBuf_, $$1: T): void;
        isSkippable(): boolean;
        getRecipes(): Internal.List<Internal.Recipe<any>>;
        get skippable(): boolean
        get recipes(): Internal.List<Internal.Recipe<any>>
    }
    type ClientboundUpdateRecipesPacket_ = ClientboundUpdateRecipesPacket;
    abstract class ScriptableObject implements Internal.SymbolScriptable, Internal.Scriptable, Internal.ConstProperties {
        constructor()
        constructor(scope: Internal.Scriptable_, prototype: Internal.Scriptable_)
        preventExtensions(): void;
        defineProperty(cx: Internal.Context_, propertyName: string, value: any, attributes: number): void;
        static getFunctionPrototype(scope: Internal.Scriptable_, cx: Internal.Context_): Internal.Scriptable;
        setAttributes(cx: Internal.Context_, index: number, attributes: number): void;
        static getArrayPrototype(scope: Internal.Scriptable_, cx: Internal.Context_): Internal.Scriptable;
        putConst(cx: Internal.Context_, name: string, start: Internal.Scriptable_, value: any): void;
        static putProperty(obj: Internal.Scriptable_, key: Internal.Symbol_, value: any, cx: Internal.Context_): void;
        defineProperty(cx: Internal.Context_, propertyName: string, delegateTo: any, getter: Internal.WrappedExecutable_, setter: Internal.WrappedExecutable_, attributes: number): void;
        static putProperty(obj: Internal.Scriptable_, name: string, value: any, cx: Internal.Context_): void;
        get(cx: Internal.Context_, index: number, start: Internal.Scriptable_): any;
        abstract getClassName(): string;
        defineFunctionProperties(cx: Internal.Context_, names: string[], clazz: typeof any, attributes: number): void;
        "delete"(cx: Internal.Context_, name: string): void;
        static putProperty(obj: Internal.Scriptable_, index: number, value: any, cx: Internal.Context_): void;
        "delete"(cx: Internal.Context_, index: number): void;
        setParentScope(m: Internal.Scriptable_): void;
        static getGeneratorFunctionPrototype(scope: Internal.Scriptable_, cx: Internal.Context_): Internal.Scriptable;
        static defineClass<T extends Internal.Scriptable>(scope: Internal.Scriptable_, clazz: T, sealed: boolean, cx: Internal.Context_): void;
        static putConstProperty(obj: Internal.Scriptable_, name: string, value: any, cx: Internal.Context_): void;
        static redefineProperty(obj: Internal.Scriptable_, name: string, isConst: boolean, cx: Internal.Context_): void;
        getTypeOf(): Internal.MemberType;
        static deleteProperty(obj: Internal.Scriptable_, index: number, cx: Internal.Context_): boolean;
        static getTopScopeValue(scope: Internal.Scriptable_, key: any, cx: Internal.Context_): any;
        getIds(cx: Internal.Context_): any[];
        defineOwnProperties(cx: Internal.Context_, props: Internal.ScriptableObject_): void;
        setAttributes(cx: Internal.Context_, name: string, attributes: number): void;
        associateValue(key: any, value: any): any;
        get(cx: Internal.Context_, key: any): any;
        get(cx: Internal.Context_, name: string, start: Internal.Scriptable_): any;
        getPrototype(cx: Internal.Context_): Internal.Scriptable;
        static getDefaultValue(object: Internal.Scriptable_, typeHint: typeof any, cx: Internal.Context_): any;
        getParentScope(): Internal.Scriptable;
        setAttributes(cx: Internal.Context_, key: Internal.Symbol_, attributes: number): void;
        static defineClass<T extends Internal.Scriptable>(scope: Internal.Scriptable_, clazz: T, cx: Internal.Context_): void;
        enumerationIteratorHasNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        isConst(name: string): boolean;
        getAttributes(cx: Internal.Context_, sym: Internal.Symbol_): number;
        isExtensible(): boolean;
        avoidObjectDetection(): boolean;
        static getClassPrototype(scope: Internal.Scriptable_, className: string, cx: Internal.Context_): Internal.Scriptable;
        setPrototype(m: Internal.Scriptable_): void;
        put(cx: Internal.Context_, name: string, start: Internal.Scriptable_, value: any): void;
        getGetterOrSetter(name: string, index: number, isSetter: boolean): any;
        getAttributes(cx: Internal.Context_, name: string): number;
        static getProperty(obj: Internal.Scriptable_, key: Internal.Symbol_, cx: Internal.Context_): any;
        defineProperty(cx: Internal.Context_, key: Internal.Symbol_, value: any, attributes: number): void;
        static getPropertyIds(cx: Internal.Context_, obj: Internal.Scriptable_): any[];
        getAssociatedValue(key: any): any;
        static hasProperty(obj: Internal.Scriptable_, name: string, cx: Internal.Context_): boolean;
        "delete"(cx: Internal.Context_, key: Internal.Symbol_): void;
        hasInstance(cx: Internal.Context_, instance: Internal.Scriptable_): boolean;
        getExternalArrayData(): Internal.ExternalArrayData;
        put(cx: Internal.Context_, index: number, start: Internal.Scriptable_, value: any): void;
        static getProperty(obj: Internal.Scriptable_, index: number, cx: Internal.Context_): any;
        isEmpty(): boolean;
        static defineConstProperty(destination: Internal.Scriptable_, propertyName: string, cx: Internal.Context_): void;
        has(cx: Internal.Context_, name: string, start: Internal.Scriptable_): boolean;
        defineConst(cx: Internal.Context_, name: string, start: Internal.Scriptable_): void;
        defineOwnProperty(cx: Internal.Context_, id: any, desc: Internal.ScriptableObject_): void;
        sealObject(cx: Internal.Context_): void;
        getDefaultValue(cx: Internal.Context_, typeHint: typeof any): any;
        setExternalArrayData(cx: Internal.Context_, array: Internal.ExternalArrayData_): void;
        has(cx: Internal.Context_, index: number, start: Internal.Scriptable_): boolean;
        static deleteProperty(obj: Internal.Scriptable_, name: string, cx: Internal.Context_): boolean;
        static defineProperty(destination: Internal.Scriptable_, propertyName: string, value: any, attributes: number, cx: Internal.Context_): void;
        getAttributes(cx: Internal.Context_, index: number): number;
        get(cx: Internal.Context_, key: Internal.Symbol_, start: Internal.Scriptable_): any;
        static hasProperty(obj: Internal.Scriptable_, key: Internal.Symbol_, cx: Internal.Context_): boolean;
        isSealed(cx: Internal.Context_): boolean;
        getAllIds(cx: Internal.Context_): any[];
        defineProperty(cx: Internal.Context_, propertyName: string, clazz: typeof any, attributes: number): void;
        setGetterOrSetter(cx: Internal.Context_, name: string, index: number, getterOrSetter: dev.latvian.mods.rhino.Callable_, isSetter: boolean): void;
        static hasProperty(obj: Internal.Scriptable_, index: number, cx: Internal.Context_): boolean;
        static defineClass<T extends Internal.Scriptable>(scope: Internal.Scriptable_, clazz: T, sealed: boolean, mapInheritance: boolean, cx: Internal.Context_): string;
        enumerationIteratorNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        size(): number;
        static getProperty(obj: Internal.Scriptable_, name: string, cx: Internal.Context_): any;
        has(cx: Internal.Context_, key: Internal.Symbol_, start: Internal.Scriptable_): boolean;
        getExternalArrayLength(): any;
        static getObjectPrototype(scope: Internal.Scriptable_, cx: Internal.Context_): Internal.Scriptable;
        static getTopLevelScope(obj: Internal.Scriptable_): Internal.Scriptable;
        put(cx: Internal.Context_, key: Internal.Symbol_, start: Internal.Scriptable_, value: any): void;
        get className(): string
        set parentScope(m: Internal.Scriptable_)
        get typeOf(): Internal.MemberType
        get parentScope(): Internal.Scriptable
        get extensible(): boolean
        set prototype(m: Internal.Scriptable_)
        get externalArrayData(): Internal.ExternalArrayData
        get empty(): boolean
        get externalArrayLength(): any
        static readonly EMPTY: 0;
        static readonly READONLY: 1;
        static readonly DONTENUM: 2;
        static readonly UNINITIALIZED_CONST: 8;
        static readonly CONST: 13;
        static readonly PERMANENT: 4;
    }
    type ScriptableObject_ = ScriptableObject;
    interface MixinAccessPlayerModelParts {
        getPlayerModelParts(): Internal.EntityDataAccessor<number>;
        get playerModelParts(): Internal.EntityDataAccessor<number>
    }
    type MixinAccessPlayerModelParts_ = MixinAccessPlayerModelParts;
    class Colour extends Internal.Enum<Internal.Colour> {
        static fromInt(colour: number): Internal.Colour;
        static valueOf(name: string): Internal.Colour;
        getG(): number;
        getNext(): this;
        getPrevious(): this;
        getHex(): number;
        getR(): number;
        getB(): number;
        static values(): Internal.Colour[];
        get g(): number
        get next(): Internal.Colour
        get previous(): Internal.Colour
        get hex(): number
        get r(): number
        get b(): number
        static readonly YELLOW: Internal.Colour;
        static readonly MAGENTA: Internal.Colour;
        static readonly GREEN: Internal.Colour;
        static readonly LIME: Internal.Colour;
        static readonly WHITE: Internal.Colour;
        static readonly ORANGE: Internal.Colour;
        static readonly BLUE: Internal.Colour;
        static readonly PINK: Internal.Colour;
        static readonly CYAN: Internal.Colour;
        static readonly VALUES: Internal.Colour[];
        static readonly PURPLE: Internal.Colour;
        static readonly RED: Internal.Colour;
        static readonly BLACK: Internal.Colour;
        static readonly LIGHT_GREY: Internal.Colour;
        static readonly GREY: Internal.Colour;
        static readonly BROWN: Internal.Colour;
        static readonly LIGHT_BLUE: Internal.Colour;
    }
    type Colour_ = "light_blue" | "magenta" | "lime" | "grey" | "brown" | "red" | "purple" | "pink" | "black" | "green" | "cyan" | Colour | "yellow" | "white" | "blue" | "orange" | "light_grey";
    class BackpackBlock extends Internal.Block implements Internal.BlockInterfaceHelper, Internal.SimpleWaterloggedBlock, Internal.EntityBlock {
        constructor()
        constructor(explosionResistance: number)
        newBlockEntity(pPos: BlockPos_, pState: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        getExplosionResistance(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, explosion: Internal.Explosion_): number;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(pLevel: Internal.Level_, pState: Internal.BlockState_, pBlockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        canEntityDestroy(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        static playerInteract(player: Internal.Player_, level: Internal.Level_, hand: Internal.InteractionHand_, hitResult: Internal.BlockHitResult_): Internal.InteractionResult;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        static readonly LEFT_TANK: Internal.BooleanProperty;
        static readonly BATTERY: Internal.BooleanProperty;
        static readonly RIGHT_TANK: Internal.BooleanProperty;
        static readonly FACING: Internal.DirectionProperty;
    }
    type BackpackBlock_ = BackpackBlock;
    class JukeboxBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly HAS_RECORD: Internal.BooleanProperty;
    }
    type JukeboxBlock_ = JukeboxBlock;
    interface TextureAtlasHolderInvoker {
        abstract emiffect$invokeGetSprite(arg0: ResourceLocation_): Internal.TextureAtlasSprite;
        (arg0: ResourceLocation): Internal.TextureAtlasSprite_;
    }
    type TextureAtlasHolderInvoker_ = TextureAtlasHolderInvoker;
    class FirstPersonMode extends Internal.Enum<Internal.FirstPersonMode> {
        static values(): Internal.FirstPersonMode[];
        static isFirstPersonPass(): boolean;
        static setFirstPersonPass(newValue: boolean): void;
        static valueOf(name: string): Internal.FirstPersonMode;
        isEnabled(): boolean;
        get firstPersonPass(): boolean
        set firstPersonPass(newValue: boolean)
        get enabled(): boolean
        static readonly THIRD_PERSON_MODEL: Internal.FirstPersonMode;
        static readonly DISABLED: Internal.FirstPersonMode;
        static readonly VANILLA: Internal.FirstPersonMode;
        static readonly NONE: Internal.FirstPersonMode;
    }
    type FirstPersonMode_ = "vanilla" | "disabled" | FirstPersonMode | "third_person_model" | "none";
    class BigInteger extends number implements Internal.Comparable<Internal.BigInteger> {
        constructor(arg0: number, arg1: number[], arg2: number, arg3: number)
        constructor(arg0: string, arg1: number)
        constructor(arg0: number, arg1: number[])
        constructor(arg0: number, arg1: number, arg2: Internal.Random_)
        constructor(arg0: number[], arg1: number, arg2: number)
        constructor(arg0: number[])
        constructor(arg0: number, arg1: Internal.Random_)
        constructor(arg0: string)
        modInverse(arg0: Internal.BigInteger_): this;
        nextProbablePrime(): this;
        static valueOf(arg0: number): Internal.BigInteger;
        andNot(arg0: Internal.BigInteger_): this;
        bitCount(): number;
        not(): this;
        compareTo(arg0: any): number;
        mod(arg0: Internal.BigInteger_): this;
        static probablePrime(arg0: number, arg1: Internal.Random_): Internal.BigInteger;
        parallelMultiply(arg0: Internal.BigInteger_): this;
        sqrtAndRemainder(): Internal.BigInteger[];
        remainder(arg0: Internal.BigInteger_): this;
        min(arg0: Internal.BigInteger_): this;
        shiftRight(arg0: number): this;
        intValueExact(): number;
        compareTo(arg0: Internal.BigInteger_): number;
        negate(): this;
        shiftLeft(arg0: number): this;
        max(arg0: Internal.BigInteger_): this;
        setBit(arg0: number): this;
        clearBit(arg0: number): this;
        subtract(arg0: Internal.BigInteger_): this;
        multiply(arg0: Internal.BigInteger_): this;
        shortValueExact(): number;
        or(arg0: Internal.BigInteger_): this;
        longValueExact(): number;
        byteValueExact(): number;
        bitLength(): number;
        divideAndRemainder(arg0: Internal.BigInteger_): Internal.BigInteger[];
        testBit(arg0: number): boolean;
        abs(): this;
        pow(arg0: number): this;
        toByteArray(): number[];
        flipBit(arg0: number): this;
        divide(arg0: Internal.BigInteger_): this;
        modPow(arg0: Internal.BigInteger_, arg1: Internal.BigInteger_): this;
        isProbablePrime(arg0: number): boolean;
        toString(arg0: number): string;
        getLowestSetBit(): number;
        and(arg0: Internal.BigInteger_): this;
        sqrt(): this;
        gcd(arg0: Internal.BigInteger_): this;
        xor(arg0: Internal.BigInteger_): this;
        add(arg0: Internal.BigInteger_): this;
        signum(): number;
        set bit(arg0: number)
        get lowestSetBit(): number
        static readonly TEN: 10;
        static readonly ONE: 1;
        static readonly TWO: 2;
        static readonly ZERO: 0;
    }
    type BigInteger_ = BigInteger;
    interface DimensionTypeAccessor {
        abstract getComp_656(): number;
        abstract getComp_641(): Internal.OptionalLong;
        get comp_656(): number
        get comp_641(): Internal.OptionalLong
    }
    type DimensionTypeAccessor_ = DimensionTypeAccessor;
    class EverlastingUpgradeItem extends Internal.UpgradeItemBase<Internal.EverlastingUpgradeItem$Wrapper> {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getType(): Internal.UpgradeType<Internal.EverlastingUpgradeItem$Wrapper>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get type(): Internal.UpgradeType<Internal.EverlastingUpgradeItem$Wrapper>
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TYPE: Internal.UpgradeType<Internal.EverlastingUpgradeItem$Wrapper>;
        static readonly UPGRADE_CONFLICT_DEFINITIONS: [Internal.IUpgradeItem$UpgradeConflictDefinition];
    }
    type EverlastingUpgradeItem_ = EverlastingUpgradeItem;
    interface Type$TypeMatcher <FT, FR> {
        abstract match<S>(arg0: com.mojang.datafixers.types.Type_<S>): Internal.Either<Internal.TypedOptic<S, any, FT, FR>, Internal.Type$FieldNotFoundException>;
        (arg0: com.mojang.datafixers.types.Type<S>): Internal.Either_<Internal.TypedOptic<S, any, FT, FR>, Internal.Type$FieldNotFoundException>;
    }
    type Type$TypeMatcher_<FT, FR> = Type$TypeMatcher<FT, FR>;
    class ClientContraption$RenderedBlocks extends Internal.Record {
        constructor(lookup: Internal.Function_<BlockPos, Internal.BlockState>, positions: Internal.Iterable_<BlockPos>)
        positions(): Internal.Iterable<BlockPos>;
        lookup(): Internal.Function<BlockPos, Internal.BlockState>;
    }
    type ClientContraption$RenderedBlocks_ = ClientContraption$RenderedBlocks;
    interface CommentedConfig$Entry extends Internal.UnmodifiableCommentedConfig$Entry, com.electronwill.nightconfig.core.Config$Entry {
        getChar(): string;
        getShortOrElse(arg0: number): number;
        abstract removeComment(): string;
        abstract setValue<T>(arg0: any): T;
        getByte(): number;
        abstract getComment(): string;
        abstract getKey(): string;
        abstract getRawValue<T>(): T;
        getIntOrElse(arg0: number): number;
        getLongOrElse(arg0: number): number;
        getOptionalLong(): Internal.OptionalLong;
        getLong(): number;
        abstract setComment(arg0: string): string;
        getByteOrElse(arg0: number): number;
        getShort(): number;
        getValue<T>(): T;
        isNull(): boolean;
        getOrElse<T>(arg0: T): T;
        getOptionalInt(): Internal.OptionalInt;
        getOptional<T>(): Internal.Optional<T>;
        getInt(): number;
        getCharOrElse(arg0: string): string;
        get "char"(): string
        set value(arg0: any)
        get "byte"(): number
        get comment(): string
        get key(): string
        get rawValue(): T
        get optionalLong(): Internal.OptionalLong
        get "long"(): number
        set comment(arg0: string)
        get "short"(): number
        get value(): T
        get "null"(): boolean
        get optionalInt(): Internal.OptionalInt
        get optional(): Internal.Optional<T>
        get "int"(): number
    }
    type CommentedConfig$Entry_ = CommentedConfig$Entry;
    class ServerRecipeBook extends Internal.RecipeBook {
        constructor()
        sendInitialRecipeBook($$0: Internal.ServerPlayer_): void;
        toNbt(): Internal.CompoundTag;
        fromNbt($$0: Internal.CompoundTag_, $$1: Internal.RecipeManager_): void;
        removeRecipes($$0: Internal.Collection_<Internal.Recipe<any>>, $$1: Internal.ServerPlayer_): number;
        addRecipes($$0: Internal.Collection_<Internal.Recipe<any>>, $$1: Internal.ServerPlayer_): number;
        static readonly RECIPE_BOOK_TAG: "recipeBook";
    }
    type ServerRecipeBook_ = ServerRecipeBook;
    class SmallConnectorBlockEntity extends Internal.AbstractConnectorBlockEntity {
        constructor(blockEntityTypeIn: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        dropWires(world: Internal.Level_, dropItems: boolean): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        removeNode(node: Internal.LocalNode_, dropWire: boolean): void;
        isNodeIndeciesConnected(in_: number, other: number): boolean;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        static readNodeOtherIndex(nbt: Internal.CompoundTag_, index: number): number;
        getNodeType(index: number): Internal.WireType;
        getOtherNodeIndex(index: number): number;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getConnectionTo(pos: BlockPos_): Internal.LocalNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        asComponentProvider(): Internal.ComponentProvider;
        removeNode(node: Internal.LocalNode_): void;
        static getWireNode(level: Internal.Level_, pos: BlockPos_): Internal.IWireNode;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getAvailableNode(pos: Vec3d_): number;
        handleWireCache(level: Internal.Level_, toDrop: Internal.Set_<Internal.LocalNode>): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        convertOldNbt(nbt: Internal.CompoundTag_): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        static getWireNodeFrom(index: number, obj: Internal.IWireNode_, localNodes: Internal.LocalNode_[], nodeCache: Internal.IWireNode_[], level: Internal.Level_): Internal.IWireNode;
        dropWires(world: Internal.Level_, player: Internal.Player_, dropItems: boolean): void;
        static readNodeWireType(nbt: Internal.CompoundTag_, index: number): Internal.WireType;
        validateLocalNodes(localNodes: Internal.LocalNode_[]): boolean;
        static dropWire(world: Internal.Level_, pos: BlockPos_, stack: Internal.ItemStack_): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        static getTypeOfConnection(level: Internal.Level_, pos1: BlockPos_, pos2: BlockPos_): Internal.WireType;
        getNodePos(index: number): BlockPos;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        static getNbtNode(nbt: Internal.CompoundTag_, index: number): Internal.CompoundTag;
        dropWire(world: Internal.Level_, node: Internal.LocalNode_): void;
        isNodeInput(index: number): boolean;
        static connect(world: Internal.Level_, pos1: BlockPos_, node1: number, pos2: BlockPos_, node2: number, type: Internal.WireType_): Internal.WireConnectResult;
        removeNode(index: number): void;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        isNodeOutput(node: number): boolean;
        static disconnect(world: Internal.Level_, pos1: BlockPos_, pos2: BlockPos_): Internal.WireConnectResult;
        isNetworkValid(node: number): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        hasAnyConnection(): boolean;
        hasConnectionTo(pos: BlockPos_): boolean;
        static readNodeBlockPos(nbt: Internal.CompoundTag_, index: number, origin: BlockPos_): BlockPos;
        getInfiniteBoundingBox(): Internal.AABB;
        awakeNetwork(world: Internal.Level_): boolean;
        hasConnection(index: number): boolean;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        disconnectWires(): void;
        getAvailableNode(): number;
        get infiniteBoundingBox(): Internal.AABB
        get availableNode(): number
        static readonly OFFSET_NORTH: Vec3d;
        static readonly OFFSET_SOUTH: Vec3d;
        static readonly OFFSET_WEST: Vec3d;
        static readonly OFFSET_DOWN: Vec3d;
        static readonly OFFSET_UP: Vec3d;
        static readonly OFFSET_EAST: Vec3d;
    }
    type SmallConnectorBlockEntity_ = SmallConnectorBlockEntity;
    class RitualIota$RitualIotaType extends Internal.IotaType<Internal.RitualIota> {
        constructor()
        deserialize(tag: Internal.Tag_, world: Internal.ServerLevel_): Internal.RitualIota;
    }
    type RitualIota$RitualIotaType_ = RitualIota$RitualIotaType;
    class IafDragonLogic {
        constructor(dragon: Internal.EntityDragonBase_)
        updateDragonServer(): void;
        updateDragonCommon(): void;
        attackTarget(target: Internal.Entity_, ridingPlayer: Internal.Player_, damage: number): boolean;
        debug(): void;
        updateDragonClient(): void;
        updateDragonAttack(): void;
    }
    type IafDragonLogic_ = IafDragonLogic;
    class DoorHingeSide extends Internal.Enum<Internal.DoorHingeSide> implements Internal.StringRepresentable {
        static values(): Internal.DoorHingeSide[];
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf($$0: string): Internal.DoorHingeSide;
        get serializedName(): string
        static readonly LEFT: Internal.DoorHingeSide;
        static readonly RIGHT: Internal.DoorHingeSide;
    }
    type DoorHingeSide_ = DoorHingeSide | "right" | "left";
    class TropicalFish$Base extends Internal.Enum<Internal.TropicalFish$Base> {
        static values(): Internal.TropicalFish$Base[];
        static valueOf($$0: string): Internal.TropicalFish$Base;
        static readonly LARGE: Internal.TropicalFish$Base;
        static readonly SMALL: Internal.TropicalFish$Base;
    }
    type TropicalFish$Base_ = "large" | "small" | TropicalFish$Base;
    class ItemSeaSerpentArrow extends Internal.ArrowItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemSeaSerpentArrow_ = ItemSeaSerpentArrow;
    interface DirectBeltInputBehaviour$InsertionCallback {
        abstract apply(arg0: Internal.TransportedItemStack_, arg1: Internal.Direction_, arg2: boolean): Internal.ItemStack;
        (arg0: Internal.TransportedItemStack, arg1: Internal.Direction, arg2: boolean): Internal.ItemStack_;
    }
    type DirectBeltInputBehaviour$InsertionCallback_ = DirectBeltInputBehaviour$InsertionCallback;
    class CreativeModeTab$ItemDisplayParameters extends Internal.Record {
        constructor($$0: Internal.FeatureFlagSet_, $$1: boolean, $$2: Internal.HolderLookup$Provider_)
        needsUpdate($$0: Internal.FeatureFlagSet_, $$1: boolean, $$2: Internal.HolderLookup$Provider_): boolean;
        holders(): Internal.HolderLookup$Provider;
        enabledFeatures(): Internal.FeatureFlagSet;
        hasPermissions(): boolean;
    }
    type CreativeModeTab$ItemDisplayParameters_ = CreativeModeTab$ItemDisplayParameters;
    interface FluidVariant extends Internal.TransferVariant<Internal.Fluid> {
        of(fluid: Internal.Fluid_, nbt: Internal.CompoundTag_): this;
        abstract getNbt(): Internal.CompoundTag;
        hasNbt(): boolean;
        abstract toNbt(): Internal.CompoundTag;
        abstract toPacket(arg0: Internal.FriendlyByteBuf_): void;
        of(fluid: Internal.Fluid_): this;
        copyOrCreateNbt(): Internal.CompoundTag;
        abstract isBlank(): boolean;
        isOf(object: Internal.Fluid_): boolean;
        fromPacket(buf: Internal.FriendlyByteBuf_): this;
        abstract getObject(): Internal.Fluid;
        nbtMatches(other: Internal.CompoundTag_): boolean;
        copyNbt(): Internal.CompoundTag;
        getFluid(): Internal.Fluid;
        fromNbt(nbt: Internal.CompoundTag_): this;
        blank(): this;
        get nbt(): Internal.CompoundTag
        get blank(): boolean
        get object(): Internal.Fluid
        get fluid(): Internal.Fluid
    }
    type FluidVariant_ = FluidVariant;
    class IdFunctionObject extends Internal.BaseFunction {
        constructor(idcall: Internal.IdFunctionCall_, tag: any, id: number, name: string, arity: number, scope: Internal.Scriptable_)
        constructor(idcall: Internal.IdFunctionCall_, tag: any, id: number, arity: number)
        enumerationIteratorNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        getTag(): any;
        addAsProperty(target: Internal.Scriptable_, cx: Internal.Context_): void;
        hasTag(tag: any): boolean;
        exportAsScopeProperty(cx: Internal.Context_): void;
        getAllIds(cx: Internal.Context_): any[];
        markAsConstructor(prototypeProperty: Internal.Scriptable_): void;
        enumerationIteratorHasNext(cx: Internal.Context_, currentId: Internal.Consumer_<any>): boolean;
        methodId(): number;
        unknown(): Internal.RuntimeException;
        initFunction(name: string, scope: Internal.Scriptable_): void;
        get tag(): any
    }
    type IdFunctionObject_ = IdFunctionObject;
    class FoodData {
        constructor()
        setExhaustion($$0: number): void;
        addExhaustion($$0: number): void;
        readAdditionalSaveData($$0: Internal.CompoundTag_): void;
        getSaturationLevel(): number;
        getFoodLevel(): number;
        addAdditionalSaveData($$0: Internal.CompoundTag_): void;
        setFoodLevel($$0: number): void;
        tick($$0: Internal.Player_): void;
        setSaturation($$0: number): void;
        eat($$0: Internal.Item_, $$1: Internal.ItemStack_): void;
        eat($$0: number, $$1: number): void;
        getLastFoodLevel(): number;
        getExhaustionLevel(): number;
        needsFood(): boolean;
        set exhaustion($$0: number)
        get saturationLevel(): number
        get foodLevel(): number
        set foodLevel($$0: number)
        set saturation($$0: number)
        get lastFoodLevel(): number
        get exhaustionLevel(): number
    }
    type FoodData_ = FoodData;
    interface IConfigSpec <T extends Internal.IConfigSpec<T>> extends Internal.UnmodifiableConfig {
        getEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        getOrElse<T>(arg0: string, arg1: T): T;
        getLong(arg0: string): number;
        getEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): T;
        getInt(arg0: Internal.List_<string>): number;
        getByteOrElse(arg0: string, arg1: number): number;
        getShortOrElse(arg0: string, arg1: number): number;
        get<T>(arg0: Internal.List_<string>): T;
        getCharOrElse(arg0: string, arg1: string): string;
        contains(arg0: string): boolean;
        getShort(arg0: Internal.List_<string>): number;
        getShortOrElse(arg0: Internal.List_<string>, arg1: number): number;
        abstract isCorrecting(): boolean;
        isNull(arg0: Internal.List_<string>): boolean;
        getIntOrElse(arg0: Internal.List_<string>, arg1: number): number;
        abstract getRaw<T>(arg0: Internal.List_<string>): T;
        getOrElse<T>(arg0: Internal.List_<string>, arg1: Internal.Supplier_<T>): T;
        getOptionalLong(arg0: string): Internal.OptionalLong;
        getOptional<T>(arg0: Internal.List_<string>): Internal.Optional<T>;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.Optional<T>;
        getEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T): T;
        getOptional<T>(arg0: string): Internal.Optional<T>;
        getShort(arg0: string): number;
        getOrElse<T>(arg0: string, arg1: Internal.Supplier_<T>): T;
        abstract entrySet(): Internal.Set<Internal.UnmodifiableConfig$Entry>;
        getChar(arg0: string): string;
        getOrElse<T>(arg0: Internal.List_<string>, arg1: T): T;
        getOptionalLong(arg0: Internal.List_<string>): Internal.OptionalLong;
        getChar(arg0: Internal.List_<string>): string;
        self(): T;
        abstract afterReload(): void;
        get<T>(arg0: string): T;
        abstract contains(arg0: Internal.List_<string>): boolean;
        getLong(arg0: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): Internal.Optional<T>;
        apply<T>(arg0: Internal.List_<string>): T;
        getLongOrElse(arg0: Internal.List_<string>, arg1: Internal.LongSupplier_): number;
        getInt(arg0: string): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_, arg3: Internal.Supplier_<T>): T;
        getLongOrElse(arg0: Internal.List_<string>, arg1: number): number;
        abstract isCorrect(arg0: Internal.CommentedConfig_): boolean;
        isEmpty(): boolean;
        getIntOrElse(arg0: Internal.List_<string>, arg1: Internal.IntSupplier_): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        getRaw<T>(arg0: string): T;
        getIntOrElse(arg0: string, arg1: Internal.IntSupplier_): number;
        isNull(arg0: string): boolean;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): T;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T): Internal.Optional<T>;
        getCharOrElse(arg0: Internal.List_<string>, arg1: string): string;
        getByte(arg0: Internal.List_<string>): number;
        getOptionalEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T): Internal.Optional<T>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T): T;
        getByteOrElse(arg0: Internal.List_<string>, arg1: number): number;
        getLongOrElse(arg0: string, arg1: number): number;
        getOptionalInt(arg0: string): Internal.OptionalInt;
        getLongOrElse(arg0: string, arg1: Internal.LongSupplier_): number;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: Internal.List_<string>, arg1: T, arg2: Internal.Supplier_<T>): T;
        getByte(arg0: string): number;
        getIntOrElse(arg0: string, arg1: number): number;
        abstract correct(arg0: Internal.CommentedConfig_): number;
        getOptionalInt(arg0: Internal.List_<string>): Internal.OptionalInt;
        abstract acceptConfig(arg0: Internal.CommentedConfig_): void;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        abstract configFormat(): Internal.ConfigFormat<any>;
        abstract size(): number;
        /**
         * @deprecated
        */
        abstract valueMap(): Internal.Map<string, any>;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: Internal.Supplier_<T>): T;
        getEnumOrElse<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_, arg3: Internal.Supplier_<T>): T;
        apply<T>(arg0: string): T;
        getEnum<T extends Internal.Enum<T>>(arg0: string, arg1: T, arg2: com.electronwill.nightconfig.core.EnumGetMethod_): T;
        get correcting(): boolean
        get empty(): boolean
    }
    type IConfigSpec_<T extends Internal.IConfigSpec<T>> = IConfigSpec<T>;
    abstract class TemplateComponent implements Internal.IVariablesAvailableCallback {
        constructor()
        onVariablesAvailable(lookup: Internal.UnaryOperator_<Internal.IVariable>): void;
        getVisibleStatus(processor: Internal.IComponentProcessor_): boolean;
        render(graphics: Internal.GuiGraphics_, page: Internal.BookPage_, mouseX: number, mouseY: number, pticks: number): void;
        onDisplayed(page: Internal.BookPage_, parent: Internal.GuiBookEntry_, left: number, top: number): void;
        build(builder: Internal.BookContentsBuilder_, page: Internal.BookPage_, entry: Internal.BookEntry_, pageNum: number): void;
        compile(level: Internal.Level_, variables: Internal.IVariableProvider_, processor: Internal.IComponentProcessor_, encapsulation: Internal.TemplateInclusion_): void;
        mouseClicked(page: Internal.BookPage_, mouseX: number, mouseY: number, mouseButton: number): boolean;
        x: number;
        y: number;
        flag: string;
        group: string;
        advancement: string;
        guard: string;
    }
    type TemplateComponent_ = TemplateComponent;
    interface LivingEntityEvents$Attack {
        abstract onAttack(arg0: Internal.LivingEntity_, arg1: DamageSource_, arg2: number): boolean;
        (arg0: Internal.LivingEntity, arg1: DamageSource, arg2: number): boolean;
    }
    type LivingEntityEvents$Attack_ = LivingEntityEvents$Attack;
    interface IPotentiallyInvisibleSpriteContents {
        abstract railways$isVisible(): boolean;
        abstract railways$shouldDoInvisibility(): boolean;
        abstract railways$uploadFrame(arg0: boolean): void;
    }
    type IPotentiallyInvisibleSpriteContents_ = IPotentiallyInvisibleSpriteContents;
    class RequestPipeBlock extends Internal.NetworkedPipeBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        static get($$0: Internal.ItemStack_): Internal.Equipable;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getEquipSound(): Internal.SoundEvent;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get equipSound(): Internal.SoundEvent
        get mod(): string
        set destroySpeed(v: number)
    }
    type RequestPipeBlock_ = RequestPipeBlock;
    class CreateAdvancement {
        constructor(id: string, b: Internal.UnaryOperator_<any>)
        awardTo(player: Internal.Player_): void;
        isAlreadyAwardedTo(player: Internal.Player_): boolean;
    }
    type CreateAdvancement_ = CreateAdvancement;
    interface BlockListeningSection {
        abstract addToCallback(arg0: Internal.ListeningBlockStatePredicate_, arg1: Internal.SectionedBlockChangeTracker_): void;
        abstract removeFromCallback(arg0: Internal.ListeningBlockStatePredicate_, arg1: Internal.SectionedBlockChangeTracker_): void;
    }
    type BlockListeningSection_ = BlockListeningSection;
    interface Char2ReferenceFunction <V> extends Internal.IntFunction<V>, it.unimi.dsi.fastutil.Function<string, V> {
        composeLong(arg0: Internal.Long2CharFunction_): Internal.Long2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        composeReference<T>(arg0: Internal.Reference2CharFunction_<T>): Internal.Reference2ReferenceFunction<T, V>;
        containsKey(arg0: string): boolean;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        composeChar(arg0: Internal.Char2CharFunction_): this;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<string, V>;
        composeShort(arg0: Internal.Short2CharFunction_): Internal.Short2ReferenceFunction<V>;
        composeDouble(arg0: Internal.Double2CharFunction_): Internal.Double2ReferenceFunction<V>;
        composeByte(arg0: Internal.Byte2CharFunction_): Internal.Byte2ReferenceFunction<V>;
        remove(arg0: string): V;
        composeFloat(arg0: Internal.Float2CharFunction_): Internal.Float2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        composeInt(arg0: Internal.Int2CharFunction_): Internal.Int2ReferenceFunction<V>;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        /**
         * @deprecated
        */
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        andThenChar(arg0: Internal.Reference2CharFunction_<V>): Internal.Char2CharFunction;
        /**
         * @deprecated
        */
        put(arg0: string, arg1: V): V;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, string>): Internal.Function<T, V>;
        abstract get(arg0: string): V;
        andThenShort(arg0: Internal.Reference2ShortFunction_<V>): Internal.Char2ShortFunction;
        andThenReference<T>(arg0: Internal.Reference2ReferenceFunction_<V, T>): Internal.Char2ReferenceFunction<T>;
        getOrDefault(arg0: string, arg1: V): V;
        andThenByte(arg0: Internal.Reference2ByteFunction_<V>): Internal.Char2ByteFunction;
        size(): number;
        apply(arg0: string): V;
        composeObject<T>(arg0: Internal.Object2CharFunction_<T>): Internal.Object2ReferenceFunction<T, V>;
        andThenLong(arg0: Internal.Reference2LongFunction_<V>): Internal.Char2LongFunction;
        clear(): void;
        put(arg0: string, arg1: V): V;
        defaultReturnValue(): V;
        andThenObject<T>(arg0: Internal.Reference2ObjectFunction_<V, T>): Internal.Char2ObjectFunction<T>;
        identity<T>(): Internal.Function<T, T>;
        andThenInt(arg0: Internal.Reference2IntFunction_<V>): Internal.Char2IntFunction;
        defaultReturnValue(arg0: V): void;
        andThenDouble(arg0: Internal.Reference2DoubleFunction_<V>): Internal.Char2DoubleFunction;
        andThenFloat(arg0: Internal.Reference2FloatFunction_<V>): Internal.Char2FloatFunction;
        (arg0: string): V;
    }
    type Char2ReferenceFunction_<V> = Char2ReferenceFunction<V>;
    abstract class FilterItem extends Internal.Item implements Internal.ItemCopyingRecipe$SupportsItemCopying, Internal.MenuProvider {
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static testDirect(filter: Internal.ItemStack_, stack: Internal.ItemStack_, matchNBT: boolean): boolean;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        setAttackSpeed(attackSpeed: number): void;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        getCreativeTab(): string;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canCopyToItem(item: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        static doPackagesHaveSameData(a: Internal.ItemStack_, b: Internal.ItemStack_): boolean;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static attribute(properties: Internal.Item$Properties_): Internal.AttributeFilterItem;
        createCopy(original: Internal.ItemStack_, count: number): Internal.ItemStack;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        abstract createMenu(arg0: number, arg1: Internal.Inventory_, arg2: Internal.Player_): Internal.AbstractContainerMenu;
        canCopyFromItem(item: Internal.ItemStack_): boolean;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static regular(properties: Internal.Item$Properties_): Internal.ListFilterItem;
        static address(properties: Internal.Item$Properties_): Internal.PackageFilterItem;
        abstract makeSummary(arg0: Internal.ItemStack_): Internal.List<net.minecraft.network.chat.Component>;
        shouldCloseCurrentScreen(): boolean;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        abstract makeStackWrapper(arg0: Internal.ItemStack_): Internal.FilterItemStack;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        setArmorToughness(armorToughness: number): void;
        abstract getFilterItems(arg0: Internal.ItemStack_): Internal.ItemStack[];
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        get creativeTab(): string
        set armorKnockbackResistance(knockbackResistance: number)
        get displayName(): net.minecraft.network.chat.Component
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
    }
    type FilterItem_ = FilterItem;
    class BlockDreadTorch extends Internal.TorchBlock implements Internal.IDreadBlock, Internal.IWallBlock {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        wallBlock(): Internal.Block;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type BlockDreadTorch_ = BlockDreadTorch;
    class DriveBlock extends Internal.AEBaseEntityBlock<Internal.DriveBlockEntity> {
        constructor()
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type DriveBlock_ = DriveBlock;
    class DataGenContext <R, E extends R> implements Internal.NonNullSupplier<E> {
        constructor(entry: Internal.NonNullSupplier_<E>, name: string, id: ResourceLocation_)
        lazy(): Internal.NonNullSupplier<E>;
        get(): E;
        static from<R, E extends R>(builder: Internal.Builder_<R, E, any, any>, type: Internal.ResourceKey_<Internal.Registry<R>>): Internal.DataGenContext<R, E>;
        getId(): ResourceLocation;
        getName(): string;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        getEntry(): E;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        get id(): ResourceLocation
        get name(): string
        get entry(): E
    }
    type DataGenContext_<R, E extends R> = DataGenContext<R, E>;
    class JsonWriter implements Internal.Closeable, Internal.Flushable {
        constructor(arg0: Internal.Writer_)
        value(arg0: boolean): this;
        value(arg0: boolean): this;
        value(arg0: number): this;
        name(arg0: string): this;
        beginObject(): this;
        isHtmlSafe(): boolean;
        flush(): void;
        value(arg0: string): this;
        value(arg0: number): this;
        jsonValue(arg0: string): this;
        endArray(): this;
        value(arg0: number): this;
        value(arg0: number): this;
        setHtmlSafe(arg0: boolean): void;
        close(): void;
        isLenient(): boolean;
        beginArray(): this;
        getSerializeNulls(): boolean;
        nullValue(): this;
        setSerializeNulls(arg0: boolean): void;
        endObject(): this;
        setIndent(arg0: string): void;
        setLenient(arg0: boolean): void;
        get htmlSafe(): boolean
        set htmlSafe(arg0: boolean)
        get lenient(): boolean
        get serializeNulls(): boolean
        set serializeNulls(arg0: boolean)
        set indent(arg0: string)
        set lenient(arg0: boolean)
    }
    type JsonWriter_ = JsonWriter;
    class MediumBogeyBlock extends Internal.CRBogeyBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.CRBogeyBlockEntity;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.CRBogeyBlockEntity>;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.CRBogeyBlockEntity>): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.CRBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type MediumBogeyBlock_ = MediumBogeyBlock;
    class Music {
        constructor($$0: Internal.Holder_<Internal.SoundEvent>, $$1: number, $$2: number, $$3: boolean)
        replaceCurrentMusic(): boolean;
        getMaxDelay(): number;
        getMinDelay(): number;
        getEvent(): Internal.Holder<Internal.SoundEvent>;
        get maxDelay(): number
        get minDelay(): number
        get event(): Internal.Holder<Internal.SoundEvent>
        static readonly CODEC: Internal.Codec<Internal.Music>;
    }
    type Music_ = Music;
    class BasinBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.BasinBlockEntity> {
        constructor(p_i48440_1_: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        static isBasin(world: Internal.LevelReader_, pos: BlockPos_): boolean;
        getBlockEntityType(): Internal.BlockEntityType<Internal.BasinBlockEntity>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.BasinBlockEntity>): void;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        static canOutputTo(world: Internal.BlockGetter_, basinPos: BlockPos_, direction: Internal.Direction_): boolean;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.BasinBlockEntity;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.BasinBlockEntity>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.BasinBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockEntityClass(): typeof Internal.BasinBlockEntity;
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityType(): Internal.BlockEntityType<Internal.BasinBlockEntity>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.BasinBlockEntity
        static readonly FACING: Internal.DirectionProperty;
    }
    type BasinBlock_ = BasinBlock;
    class MediafiedItemManager$Index {
        constructor(storage: Internal.UUID_, index: number)
        component2(): number;
        static readFromNbt(tag: Internal.CompoundTag_): Internal.MediafiedItemManager$Index;
        component1(): Internal.UUID;
        static copy$default(arg0: Internal.MediafiedItemManager$Index_, arg1: Internal.UUID_, arg2: number, arg3: number, arg4: any): Internal.MediafiedItemManager$Index;
        copy(storage: Internal.UUID_, index: number): this;
        writeToNbt(tag: Internal.CompoundTag_): void;
        getStorage(): Internal.UUID;
        getIndex(): number;
        get storage(): Internal.UUID
        get index(): number
        static readonly TAG_STORAGE: "storage";
        static readonly Companion: Internal.MediafiedItemManager$Index$Companion;
        static readonly TAG_INDEX: "index";
    }
    type MediafiedItemManager$Index_ = MediafiedItemManager$Index;
    class InvisibleBogeyBlock extends Internal.AbstractBogeyBlock<Internal.InvisibleBogeyBlockEntity> implements Internal.ProperWaterloggedBlock, Internal.IBE<Internal.InvisibleBogeyBlockEntity>, Internal.SpecialBlockItemRequirement {
        constructor(props: Internal.BlockBehaviour$Properties_)
        getConnectorAnchorOffset(): Vec3d;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.InvisibleBogeyBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.InvisibleBogeyBlockEntity;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.InvisibleBogeyBlockEntity>;
        setDestroySpeed(v: number): void;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.InvisibleBogeyBlockEntity>;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        getBlockEntityClass(): typeof Internal.InvisibleBogeyBlockEntity;
        emi(): Internal.EmiStack;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.InvisibleBogeyBlockEntity>): void;
        get connectorAnchorOffset(): Vec3d
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityType(): Internal.BlockEntityType<Internal.InvisibleBogeyBlockEntity>
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.InvisibleBogeyBlockEntity
    }
    type InvisibleBogeyBlock_ = InvisibleBogeyBlock;
    class ModifierSalvage implements Internal.ICustomOutputRecipe<net.minecraft.world.Container> {
        constructor(id: ResourceLocation_, toolIngredient: Internal.Ingredient_, maxToolSize: number, modifier: Internal.ModifierId_, minLevel: number, maxLevel: number, slots: Internal.SlotType$SlotCount_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getMaxToolSize(): number;
        getSerializer(): Internal.RecipeSerializer<any>;
        /**
         * @deprecated
        */
        assemble(inv: net.minecraft.world.Container_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getId(): ResourceLocation;
        getModifier(): Internal.ModifierId;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        /**
         * @deprecated
        */
        matches(inv: net.minecraft.world.Container_, level: Internal.Level_): boolean;
        getMod(): string;
        getRemainingItems($$0: net.minecraft.world.Container_): Internal.NonNullList<Internal.ItemStack>;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(access: Internal.RegistryAccess_): Internal.ItemStack;
        matches(stack: Internal.ItemStack_, tool: Internal.IToolStackView_, originalLevel: number): boolean;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        updateTool(tool: Internal.IToolStackView_): void;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get maxToolSize(): number
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get modifier(): Internal.ModifierId
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
    }
    type ModifierSalvage_ = ModifierSalvage;
    class BonusChestFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type BonusChestFeature_ = BonusChestFeature;
    interface Char2IntFunction extends Internal.IntUnaryOperator, it.unimi.dsi.fastutil.Function<string, number> {
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, string>): Internal.Function<T, number>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        defaultReturnValue(): number;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Char2CharFunction;
        remove(arg0: string): number;
        composeShort(arg0: Internal.Short2CharFunction_): Internal.Short2IntFunction;
        composeByte(arg0: Internal.Byte2CharFunction_): Internal.Byte2IntFunction;
        andThen(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        put(arg0: string, arg1: number): number;
        put(arg0: string, arg1: number): number;
        containsKey(arg0: string): boolean;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        getOrDefault(arg0: string, arg1: number): number;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Char2ObjectFunction<T>;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Char2LongFunction;
        composeReference<T>(arg0: Internal.Reference2CharFunction_<T>): Internal.Reference2IntFunction<T>;
        compose(arg0: Internal.IntUnaryOperator_): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        applyAsInt(arg0: number): number;
        identity(): Internal.IntUnaryOperator;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Char2ReferenceFunction<T>;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        composeChar(arg0: Internal.Char2CharFunction_): this;
        andThenInt(arg0: Internal.Int2IntFunction_): this;
        composeInt(arg0: Internal.Int2CharFunction_): Internal.Int2IntFunction;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Char2ShortFunction;
        apply(arg0: string): number;
        composeDouble(arg0: Internal.Double2CharFunction_): Internal.Double2IntFunction;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Char2DoubleFunction;
        abstract get(arg0: string): number;
        size(): number;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Char2FloatFunction;
        defaultReturnValue(arg0: number): void;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<string, T>;
        clear(): void;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Char2ByteFunction;
        composeObject<T>(arg0: Internal.Object2CharFunction_<T>): Internal.Object2IntFunction<T>;
        composeLong(arg0: Internal.Long2CharFunction_): Internal.Long2IntFunction;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        composeFloat(arg0: Internal.Float2CharFunction_): Internal.Float2IntFunction;
        /**
         * @deprecated
        */
        get(arg0: any): any;
        (arg0: string): number;
    }
    type Char2IntFunction_ = Char2IntFunction;
    abstract class AbstractChuteBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.ReducedDestroyEffects, Internal.IBE<Internal.ChuteBlockEntity> {
        constructor(p_i48440_1_: Internal.BlockBehaviour$Properties_)
        static isTransparentChute(state: Internal.BlockState_): boolean;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.ChuteBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        abstract updateChuteState(arg0: Internal.BlockState_, arg1: Internal.BlockState_, arg2: Internal.BlockGetter_, arg3: BlockPos_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        setRequiresTool(v: boolean): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.ChuteBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        static getChuteFacing(state: Internal.BlockState_): Internal.Direction;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        static isChute(state: Internal.BlockState_): boolean;
        getBlockEntityClass(): typeof Internal.ChuteBlockEntity;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.ChuteBlockEntity>): void;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        abstract getBlockEntityType(): Internal.BlockEntityType<Internal.ChuteBlockEntity>;
        static isOpenChute(state: Internal.BlockState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.ChuteBlockEntity>;
        isTransparent(state: Internal.BlockState_): boolean;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        getFacing(state: Internal.BlockState_): Internal.Direction;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        emi(): Internal.EmiStack;
        isOpen(state: Internal.BlockState_): boolean;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get blockEntityClass(): typeof Internal.ChuteBlockEntity
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.ChuteBlockEntity>
    }
    type AbstractChuteBlock_ = AbstractChuteBlock;
    abstract class CoralFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor($$0: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type CoralFeature_ = CoralFeature;
    class RestockUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.RestockUpgradeWrapper, Internal.RestockUpgradeItem> implements Internal.IItemHandlerInteractionUpgrade, Internal.IContentsFilteredUpgrade {
        constructor(backpackWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        canBeDisabled(): boolean;
        getFilterLogic(): Internal.ContentsFilterLogic;
        onHandlerInteract(itemHandler: Internal.SlottedStorage_<Internal.ItemVariant>, player: Internal.Player_): void;
        hideSettingsTab(): boolean;
        onAdded(): void;
        onBeforeRemoved(): void;
        get filterLogic(): Internal.ContentsFilterLogic
    }
    type RestockUpgradeWrapper_ = RestockUpgradeWrapper;
    class NetherWartBlock extends Internal.BushBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly AGE: Internal.IntegerProperty;
        static readonly MAX_AGE: 3;
    }
    type NetherWartBlock_ = NetherWartBlock;
    abstract class FlowingFluid extends Internal.Fluid implements Internal.FlowingFluidAccessor, io.github.fabricators_of_create.porting_lib.fluids.mixin.FlowingFluidAccessor {
        constructor()
        method_15782($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.FluidState_): Vec3d;
        static getCacheKey($$0: BlockPos_, $$1: BlockPos_): number;
        getSource($$0: boolean): Internal.FluidState;
        canPassThroughWall($$0: Internal.Direction_, $$1: Internal.BlockGetter_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: BlockPos_, $$5: Internal.BlockState_): boolean;
        abstract getFlowing(): Internal.Fluid;
        canHoldFluid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        spreadToSides($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.FluidState_, $$3: Internal.BlockState_): void;
        method_15778($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.FluidState_): void;
        canPassThrough($$0: Internal.BlockGetter_, $$1: Internal.Fluid_, $$2: BlockPos_, $$3: Internal.BlockState_, $$4: Internal.Direction_, $$5: BlockPos_, $$6: Internal.BlockState_, $$7: Internal.FluidState_): boolean;
        affectsFlow($$0: Internal.FluidState_): boolean;
        getFlowing($$0: number, $$1: boolean): Internal.FluidState;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        create$getNewLiquid(arg0: Internal.Level_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.FluidState;
        abstract getSource(): Internal.Fluid;
        arch$registryName(): ResourceLocation;
        isSourceBlockOfThisType($$0: Internal.FluidState_): boolean;
        callCanConvertToSource(arg0: Internal.Level_): boolean;
        get flowing(): Internal.Fluid
        get source(): Internal.Fluid
        static readonly FALLING: Internal.BooleanProperty;
        static readonly LEVEL: Internal.IntegerProperty;
        readonly shapes: Internal.Map<Internal.FluidState, Internal.VoxelShape>;
    }
    type FlowingFluid_ = FlowingFluid;
    class IntOpenHashSet extends Internal.AbstractIntSet implements Internal.Cloneable, Internal.Hash, Internal.Serializable {
        constructor()
        constructor(arg0: Internal.IntCollection_)
        constructor(arg0: Internal.Iterator_<any>)
        constructor(arg0: number)
        constructor(arg0: number[])
        constructor(arg0: number[], arg1: number, arg2: number, arg3: number)
        constructor(arg0: Internal.Iterator_<any>, arg1: number)
        constructor(arg0: number, arg1: number)
        constructor(arg0: number[], arg1: number)
        constructor(arg0: Internal.IntCollection_, arg1: number)
        constructor(arg0: Internal.Collection_<number>)
        constructor(arg0: number[], arg1: number, arg2: number)
        constructor(arg0: Internal.Collection_<number>, arg1: number)
        constructor(arg0: Internal.IntIterator_)
        constructor(arg0: Internal.IntIterator_, arg1: number)
        static of(arg0: number, arg1: number, arg2: number): Internal.IntOpenHashSet;
        /**
         * @deprecated
        */
        stream(): Internal.Stream<number>;
        /**
         * @deprecated
        */
        add(arg0: number): boolean;
        trim(arg0: number): boolean;
        static toSetWithExpectedSize(arg0: Internal.IntStream_, arg1: number): Internal.IntOpenHashSet;
        static toSet(arg0: Internal.IntStream_): Internal.IntOpenHashSet;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E, arg9: E): Internal.Set<E>;
        intStream(): Internal.IntStream;
        toArray<T>(arg0: Internal.IntFunction_<T[]>): T[];
        static of<E>(arg0: E, arg1: E): Internal.Set<E>;
        clone(): this;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E): Internal.Set<E>;
        intParallelStream(): Internal.IntStream;
        static of<E>(arg0: E, arg1: E, arg2: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E): Internal.Set<E>;
        intIterator(): Internal.IntIterator;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E): Internal.Set<E>;
        /**
         * @deprecated
        */
        contains(arg0: any): boolean;
        removeIf(arg0: Internal.IntPredicate_): boolean;
        trim(): boolean;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E): Internal.Set<E>;
        abstract toArray<T>(arg0: T[]): T[];
        /**
         * @deprecated
        */
        forEach(arg0: Internal.Consumer_<number>): void;
        /**
         * @deprecated
        */
        parallelStream(): Internal.Stream<number>;
        /**
         * @deprecated
        */
        remove(arg0: any): boolean;
        /**
         * @deprecated
        */
        removeIf(arg0: Internal.Predicate_<number>): boolean;
        static of(): Internal.IntOpenHashSet;
        intSpliterator(): Internal.IntSpliterator;
        /**
         * @deprecated
        */
        add(arg0: any): boolean;
        static of<E>(arg0: E): Internal.Set<E>;
        static of<E>(arg0: E, arg1: E, arg2: E, arg3: E, arg4: E, arg5: E, arg6: E, arg7: E, arg8: E): Internal.Set<E>;
        static of<E>(...arg0: E[]): Internal.Set<E>;
        spliterator(): Internal.Spliterator<any>;
        static of(arg0: number): Internal.IntOpenHashSet;
        static of(...arg0: number[]): Internal.IntOpenHashSet;
        static copyOf<E>(arg0: Internal.Collection_<E>): Internal.Set<E>;
        static of(arg0: number, arg1: number): Internal.IntOpenHashSet;
    }
    type IntOpenHashSet_ = IntOpenHashSet;
    interface ProfileKeyPairManager {
        abstract prepareKeyPair(): Internal.CompletableFuture<Internal.Optional<Internal.ProfileKeyPair>>;
        create($$0: Internal.UserApiService_, $$1: Internal.User_, $$2: Internal.Path_): this;
        abstract shouldRefreshKeyPair(): boolean;
        readonly EMPTY_KEY_MANAGER: Internal.ProfileKeyPairManager;
    }
    type ProfileKeyPairManager_ = ProfileKeyPairManager;
    class FlapDisplaySection {
        constructor(width: number, cycle: string, singleFlap: boolean, hasGap: boolean)
        static getFlapCycle(key: string): string[];
        renderCharsIndividually(): boolean;
        write(): Internal.CompoundTag;
        getSize(): number;
        update(tag: Internal.CompoundTag_): void;
        getText(): net.minecraft.network.chat.Component;
        rightAligned(): this;
        static load(tag: Internal.CompoundTag_): Internal.FlapDisplaySection;
        tick(instant: boolean): number;
        refresh(transition: boolean): void;
        setText(component: net.minecraft.network.chat.Component_): void;
        wideFlaps(): this;
        get size(): number
        get text(): net.minecraft.network.chat.Component
        set text(component: net.minecraft.network.chat.Component_)
        static readonly WIDE_MONOSPACE: 9.0;
        static readonly MONOSPACE: 7.0;
    }
    type FlapDisplaySection_ = FlapDisplaySection;
    interface SignatureValidator {
        abstract validate(arg0: Internal.SignatureUpdater_, arg1: number[]): boolean;
        from($$0: Internal.ServicesKeySet_, $$1: Internal.ServicesKeyType_): this;
        validate($$0: number[], $$1: number[]): boolean;
        from($$0: Internal.PublicKey_, $$1: string): this;
        (arg0: Internal.SignatureUpdater, arg1: number[]): boolean;
        readonly NO_VALIDATION: Internal.SignatureValidator;
        readonly LOGGER: Internal.Log4jLogger;
    }
    type SignatureValidator_ = SignatureValidator;
    interface TextureAtlasSprite$AnimatedTextureAccessor {
        abstract port_lib$getFrameX(arg0: number): number;
        abstract port_lib$getFrameY(arg0: number): number;
    }
    type TextureAtlasSprite$AnimatedTextureAccessor_ = TextureAtlasSprite$AnimatedTextureAccessor;
    interface Npc {
    }
    type Npc_ = Npc;
    class BlockTintFunction$Fixed extends Internal.Record implements Internal.BlockTintFunction {
        constructor(color: dev.latvian.mods.rhino.mod.util.color.Color_)
        static of(cx: Internal.Context_, o: any): Internal.BlockTintFunction;
        getColor(state: Internal.BlockState_, level: Internal.BlockAndTintGetter_, pos: BlockPos_, index: number): dev.latvian.mods.rhino.mod.util.color.Color;
        color(): dev.latvian.mods.rhino.mod.util.color.Color;
    }
    type BlockTintFunction$Fixed_ = BlockTintFunction$Fixed;
    class BlockPattern$BlockPatternMatch {
        constructor($$0: BlockPos_, $$1: Internal.Direction_, $$2: Internal.Direction_, $$3: Internal.LoadingCache_<BlockPos, Internal.BlockInWorld>, $$4: number, $$5: number, $$6: number)
        getDepth(): number;
        getBlock($$0: number, $$1: number, $$2: number): Internal.BlockInWorld;
        getWidth(): number;
        getUp(): Internal.Direction;
        getHeight(): number;
        getFrontTopLeft(): BlockPos;
        getForwards(): Internal.Direction;
        get depth(): number
        get width(): number
        get up(): Internal.Direction
        get height(): number
        get frontTopLeft(): BlockPos
        get forwards(): Internal.Direction
    }
    type BlockPattern$BlockPatternMatch_ = BlockPattern$BlockPatternMatch;
    interface HoglinBase {
        abstract getAttackAnimationRemainingTicks(): number;
        hurtAndThrowTarget($$0: Internal.LivingEntity_, $$1: Internal.LivingEntity_): boolean;
        throwTarget($$0: Internal.LivingEntity_, $$1: Internal.LivingEntity_): void;
        get attackAnimationRemainingTicks(): number
        (): number;
        readonly ATTACK_ANIMATION_DURATION: 10;
    }
    type HoglinBase_ = HoglinBase;
    interface ICraftingMachine {
        abstract getCraftingMachineInfo(): Internal.PatternContainerGroup;
        abstract acceptsPlans(): boolean;
        of(blockEntity: Internal.BlockEntity_, side: Internal.Direction_): this;
        of(level: Internal.Level_, pos: BlockPos_, side: Internal.Direction_, blockEntity: Internal.BlockEntity_): this;
        abstract pushPattern(arg0: Internal.IPatternDetails_, arg1: Internal.KeyCounter_[], arg2: Internal.Direction_): boolean;
        get craftingMachineInfo(): Internal.PatternContainerGroup
        readonly SIDED: Internal.BlockApiLookup<Internal.ICraftingMachine, Internal.Direction>;
    }
    type ICraftingMachine_ = ICraftingMachine;
    abstract class BaseComfortsBlockEntity extends Internal.BlockEntity implements Internal.Nameable {
        constructor(blockEntityType: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_, colorIn: Internal.DyeColor_)
        constructor(blockEntityType: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setName(name: net.minecraft.network.chat.Component_): void;
        getUpdatePacket(): Internal.Packet<any>;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        getColor(): Internal.DyeColor;
        invalidateCaps(): void;
        abstract getName(): net.minecraft.network.chat.Component;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        getUpdatePacket(): Internal.ClientboundBlockEntityDataPacket;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setColor(color: Internal.DyeColor_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getCustomName(): net.minecraft.network.chat.Component;
        get displayName(): net.minecraft.network.chat.Component
        set name(name: net.minecraft.network.chat.Component_)
        get updatePacket(): Internal.Packet<any>
        get color(): Internal.DyeColor
        get name(): net.minecraft.network.chat.Component
        get updatePacket(): Internal.ClientboundBlockEntityDataPacket
        set color(color: Internal.DyeColor_)
        get customName(): net.minecraft.network.chat.Component
    }
    type BaseComfortsBlockEntity_ = BaseComfortsBlockEntity;
    class TankPosition extends Internal.Enum<Internal.TankPosition> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static valueOf(name: string): Internal.TankPosition;
        static values(): Internal.TankPosition[];
        get serializedName(): string
        static readonly LEFT: Internal.TankPosition;
        static readonly RIGHT: Internal.TankPosition;
    }
    type TankPosition_ = TankPosition | "right" | "left";
    interface AgriCrop extends Internal.AgriGenomeProvider, Internal.IAgriFertilizable {
        getGrowthPercent(): number;
        abstract getSoil(): Internal.Optional<Internal.AgriSoil>;
        abstract applyGrowthTick(): void;
        abstract plantGenome(arg0: Internal.AgriGenome_, arg1: Internal.LivingEntity_): void;
        asBlockEntity(): Internal.BlockEntity;
        abstract getPlant(): Internal.AgriPlant;
        abstract setWeedGrowthStage(arg0: Internal.AgriGrowthStage_): void;
        isFertile(): boolean;
        harvest(consumer: Internal.Consumer_<Internal.ItemStack>, entity: Internal.LivingEntity_): boolean;
        abstract setGrowthStage(arg0: Internal.AgriGrowthStage_): void;
        abstract method_11010(): Internal.BlockState;
        abstract getPlantId(): string;
        abstract getWeed(): Internal.AgriWeed;
        abstract removeWeeds(): void;
        abstract removeGenome(): boolean;
        isFullyGrown(): boolean;
        shouldWeedsActivate(): boolean;
        abstract acceptsFertilizer(arg0: Internal.AgriFertilizer_): boolean;
        plantGenome(genome: Internal.AgriGenome_): void;
        abstract hasWeeds(): boolean;
        abstract method_10997(): Internal.Level;
        abstract getWeedGrowthStage(): Internal.AgriGrowthStage;
        abstract getHarvestProducts(arg0: Internal.Consumer_<Internal.ItemStack>): void;
        abstract setWeed(arg0: string, arg1: Internal.AgriWeed_): void;
        abstract getWeedId(): string;
        abstract isCrossCropSticks(): boolean;
        abstract hasPlant(): boolean;
        abstract getFertilityResponse(): Internal.AgriGrowthResponse;
        abstract getClippingProducts(arg0: Internal.Consumer_<Internal.ItemStack>, arg1: Internal.ItemStack_): void;
        onApplyFertilizer(fertilizer: Internal.AgriFertilizer_, rand: Internal.RandomSource_): void;
        abstract getGrowthStage(): Internal.AgriGrowthStage;
        abstract hasCropSticks(): boolean;
        canBeHarvested(): boolean;
        abstract getGenome(): Internal.AgriGenome;
        abstract method_11016(): BlockPos;
        get growthPercent(): number
        get soil(): Internal.Optional<Internal.AgriSoil>
        get plant(): Internal.AgriPlant
        set weedGrowthStage(arg0: Internal.AgriGrowthStage_)
        get fertile(): boolean
        set growthStage(arg0: Internal.AgriGrowthStage_)
        get plantId(): string
        get weed(): Internal.AgriWeed
        get fullyGrown(): boolean
        get weedGrowthStage(): Internal.AgriGrowthStage
        get weedId(): string
        get crossCropSticks(): boolean
        get fertilityResponse(): Internal.AgriGrowthResponse
        get growthStage(): Internal.AgriGrowthStage
        get genome(): Internal.AgriGenome
    }
    type AgriCrop_ = AgriCrop;
    abstract class AbstractPacket {
        constructor()
        abstract encode(): Internal.FriendlyByteBuf;
        abstract getPacketID(): ResourceLocation;
        get packetID(): ResourceLocation
    }
    type AbstractPacket_ = AbstractPacket;
    class ValueLayouts$OfIntImpl extends Internal.ValueLayouts$AbstractValueLayout<Internal.ValueLayouts$OfIntImpl> implements Internal.ValueLayout$OfInt {
        static sequenceLayout(arg0: number, arg1: Internal.MemoryLayout_): Internal.SequenceLayout;
        withoutName(): Internal.ValueLayout$OfInt;
        static sequenceLayout(arg0: Internal.MemoryLayout_): Internal.SequenceLayout;
        withOrder(arg0: Internal.ByteOrder_): Internal.ValueLayout$OfInt;
        byteOffset(...arg0: any_[]): number;
        withByteAlignment(arg0: number): Internal.MemoryLayout;
        static structLayout(...arg0: Internal.MemoryLayout_[]): Internal.StructLayout;
        withName(arg0: string): Internal.ValueLayout$OfInt;
        select(...arg0: any_[]): Internal.MemoryLayout;
        sliceHandle(...arg0: any_[]): Internal.MethodHandle;
        static paddingLayout(arg0: number): Internal.PaddingLayout;
        varHandle(...arg0: any_[]): Internal.VarHandle;
        byteOffsetHandle(...arg0: any_[]): Internal.MethodHandle;
        static of(arg0: Internal.ByteOrder_): Internal.ValueLayout$OfInt;
        static unionLayout(...arg0: Internal.MemoryLayout_[]): Internal.UnionLayout;
    }
    type ValueLayouts$OfIntImpl_ = ValueLayouts$OfIntImpl;
    class StringArgumentType$StringType extends Internal.Enum<Internal.StringArgumentType$StringType> {
        getExamples(): Internal.Collection<string>;
        static values(): Internal.StringArgumentType$StringType[];
        static valueOf(arg0: string): Internal.StringArgumentType$StringType;
        get examples(): Internal.Collection<string>
        static readonly QUOTABLE_PHRASE: Internal.StringArgumentType$StringType;
        static readonly GREEDY_PHRASE: Internal.StringArgumentType$StringType;
        static readonly SINGLE_WORD: Internal.StringArgumentType$StringType;
    }
    type StringArgumentType$StringType_ = StringArgumentType$StringType | "greedy_phrase" | "single_word" | "quotable_phrase";
    class ClientboundLevelParticlesPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor($$0: T, $$1: boolean, $$2: number, $$3: number, $$4: number, $$5: number, $$6: number, $$7: number, $$8: number, $$9: number)
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        getCount(): number;
        getMaxSpeed(): number;
        getParticle(): Internal.ParticleOptions;
        isOverrideLimiter(): boolean;
        isSkippable(): boolean;
        getX(): number;
        getXDist(): number;
        getY(): number;
        getZ(): number;
        getYDist(): number;
        handle($$0: Internal.ClientGamePacketListener_): void;
        getZDist(): number;
        get count(): number
        get maxSpeed(): number
        get particle(): Internal.ParticleOptions
        get overrideLimiter(): boolean
        get skippable(): boolean
        get x(): number
        get XDist(): number
        get y(): number
        get z(): number
        get YDist(): number
        get ZDist(): number
    }
    type ClientboundLevelParticlesPacket_ = ClientboundLevelParticlesPacket;
    interface Navigation$StationTest {
        abstract test(arg0: number, arg1: number, arg2: Internal.Map_<Internal.TrackEdge, net.createmod.catnip.data.Pair<boolean, Internal.Couple<Internal.TrackNode>>>, arg3: net.createmod.catnip.data.Pair_<Internal.Couple<Internal.TrackNode>, Internal.TrackEdge>, arg4: Internal.GlobalStation_): boolean;
        (arg0: number, arg1: number, arg2: Internal.Map<Internal.TrackEdge, net.createmod.catnip.data.Pair<boolean, Internal.Couple<Internal.TrackNode>>>, arg3: net.createmod.catnip.data.Pair<Internal.Couple<Internal.TrackNode>, Internal.TrackEdge>, arg4: Internal.GlobalStation): boolean;
    }
    type Navigation$StationTest_ = Navigation$StationTest;
    abstract class FileLock implements Internal.AutoCloseable {
        abstract isValid(): boolean;
        overlaps(arg0: number, arg1: number): boolean;
        position(): number;
        close(): void;
        abstract release(): void;
        isShared(): boolean;
        size(): number;
        channel(): Internal.FileChannel;
        acquiredBy(): Internal.Channel;
        get valid(): boolean
        get shared(): boolean
    }
    type FileLock_ = FileLock;
    class Locale$FilteringMode extends Internal.Enum<Internal.Locale$FilteringMode> {
        static valueOf(arg0: string): Internal.Locale$FilteringMode;
        static values(): Internal.Locale$FilteringMode[];
        static readonly EXTENDED_FILTERING: Internal.Locale$FilteringMode;
        static readonly IGNORE_EXTENDED_RANGES: Internal.Locale$FilteringMode;
        static readonly AUTOSELECT_FILTERING: Internal.Locale$FilteringMode;
        static readonly MAP_EXTENDED_RANGES: Internal.Locale$FilteringMode;
        static readonly REJECT_EXTENDED_RANGES: Internal.Locale$FilteringMode;
    }
    type Locale$FilteringMode_ = "reject_extended_ranges" | Locale$FilteringMode | "extended_filtering" | "ignore_extended_ranges" | "autoselect_filtering" | "map_extended_ranges";
    class DragonForgeRecipe$Serializer implements Internal.RecipeSerializer<Internal.DragonForgeRecipe> {
        constructor()
        read(recipeId: ResourceLocation_, json: Internal.JsonObject_): Internal.DragonForgeRecipe;
        read(recipeId: ResourceLocation_, buffer: Internal.FriendlyByteBuf_): Internal.DragonForgeRecipe;
        static register<S extends Internal.RecipeSerializer<T>, T extends Internal.Recipe<any>>($$0: string, $$1: S): S;
        fromJson(arg0: ResourceLocation_, arg1: Internal.JsonObject_): Internal.Recipe<any>;
        write(buffer: Internal.FriendlyByteBuf_, recipe: Internal.DragonForgeRecipe_): void;
        toNetwork(arg0: Internal.FriendlyByteBuf_, arg1: Internal.Recipe_<any>): void;
        fromNetwork(arg0: ResourceLocation_, arg1: Internal.FriendlyByteBuf_): Internal.Recipe<any>;
    }
    type DragonForgeRecipe$Serializer_ = DragonForgeRecipe$Serializer;
    class FuelTankBlockEntity extends Internal.SmartBlockEntity implements Internal.IHaveGoggleInformation, Internal.SidedStorageBlockEntity, Internal.CustomRenderBoundingBoxBlockEntity, Internal.IMultiBlockEntityContainer$Fluid {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        setTankSize(tank: number, blocks: number): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        setController(controller: BlockPos_): void;
        getTankInventory(): io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getTank(tank: number): io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank;
        queueConnectivityUpdate(): void;
        static getMaxHeight(): number;
        preventConnectivityUpdate(): void;
        getTankSize(tank: number): number;
        onLoad(): void;
        static getCapacityMultiplier(): number;
        getItemStorage(side: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getFluid(tank: number): Internal.FluidStack;
        hasTank(): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        getWidth(): number;
        modifyExtraData(data: any): any;
        getControllerBE(): this;
        asComponentProvider(): Internal.ComponentProvider;
        getController(): BlockPos;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setWindows(window: boolean): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getFluidLevel(): Internal.LerpedFloat;
        getMainConnectionAxis(): Internal.Direction$Axis;
        getRenderBoundingBox(): Internal.AABB;
        removeController(keepFluids: boolean): void;
        isController(): boolean;
        setExtraData(data: any): void;
        sendDataImmediately(): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getLastKnownPos(): BlockPos;
        getFluidStorage(direction: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTotalTankSize(): number;
        applyFluidTankSize(blocks: number): void;
        setFluidLevel(fluidLevel: Internal.LerpedFloat_): void;
        notifyMultiUpdated(): void;
        getExtraData(): any;
        setWidth(width: number): void;
        getHeight(): number;
        getMaxLength(longAxis: Internal.Direction$Axis_, width: number): number;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getMainAxisOf(be: Internal.BlockEntity_): Internal.Direction$Axis;
        getMaxWidth(): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        static getMaxSize(): number;
        getInfiniteBoundingBox(): Internal.AABB;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getFillState(): number;
        toggleWindows(): void;
        addToGoggleTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean): boolean;
        setHeight(height: number): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        set controller(controller: BlockPos_)
        get tankInventory(): io.github.fabricators_of_create.porting_lib.transfer.fluid.FluidTank
        get maxHeight(): number
        get capacityMultiplier(): number
        get width(): number
        get controllerBE(): Internal.FuelTankBlockEntity
        get controller(): BlockPos
        set windows(window: boolean)
        get fluidLevel(): Internal.LerpedFloat
        get mainConnectionAxis(): Internal.Direction$Axis
        get renderBoundingBox(): Internal.AABB
        get controller(): boolean
        set extraData(data: any)
        get lastKnownPos(): BlockPos
        get totalTankSize(): number
        set fluidLevel(fluidLevel: Internal.LerpedFloat_)
        get extraData(): any
        set width(width: number)
        get height(): number
        get maxWidth(): number
        get maxSize(): number
        get infiniteBoundingBox(): Internal.AABB
        get fillState(): number
        set height(height: number)
    }
    type FuelTankBlockEntity_ = FuelTankBlockEntity;
    interface MutableQuadView extends Internal.QuadView {
        abstract material(arg0: Internal.RenderMaterial_): this;
        abstract normalX(arg0: number): number;
        /**
         * @deprecated
        */
        spriteBake(spriteIndex: number, sprite: Internal.TextureAtlasSprite_, bakeFlags: number): this;
        abstract x(arg0: number): number;
        abstract cullFace(): Internal.Direction;
        abstract v(arg0: number): number;
        abstract color(arg0: number): number;
        abstract copyNormal(arg0: number, arg1: Vec3f_): Vec3f;
        abstract copyFrom(arg0: Internal.QuadView_): this;
        abstract z(arg0: number): number;
        abstract normal(arg0: number, arg1: number, arg2: number, arg3: number): this;
        /**
         * @deprecated
        */
        spriteV(vertexIndex: number, spriteIndex: number): number;
        abstract nominalFace(arg0: Internal.Direction_): this;
        abstract nominalFace(): Internal.Direction;
        abstract hasNormal(arg0: number): boolean;
        abstract lightFace(): Internal.Direction;
        abstract cullFace(arg0: Internal.Direction_): this;
        /**
         * @deprecated
        */
        sprite(vertexIndex: number, spriteIndex: number, uv: Internal.Vec2_): this;
        abstract colorIndex(): number;
        abstract lightmap(arg0: number): number;
        abstract tag(arg0: number): this;
        /**
         * @deprecated
        */
        spriteColor(vertexIndex: number, spriteIndex: number): number;
        abstract tag(): number;
        /**
         * @deprecated
        */
        fromVanilla(quadData: number[], startIndex: number, isItem: boolean): this;
        /**
         * @deprecated
        */
        toBakedQuad(spriteIndex: number, sprite: Internal.TextureAtlasSprite_, isItem: boolean): Internal.BakedQuad;
        abstract uv(arg0: number, arg1: number, arg2: number): this;
        abstract color(arg0: number, arg1: number): this;
        abstract spriteBake(arg0: Internal.TextureAtlasSprite_, arg1: number): this;
        abstract colorIndex(arg0: number): this;
        abstract normalZ(arg0: number): number;
        abstract copyUv(arg0: number, arg1: Internal.Vector2f_): Internal.Vector2f;
        /**
         * @deprecated
        */
        spriteColor(vertexIndex: number, spriteIndex: number, color: number): this;
        abstract u(arg0: number): number;
        toBakedQuad(sprite: Internal.TextureAtlasSprite_): Internal.BakedQuad;
        pos(vertexIndex: number, pos: Vec3f_): this;
        lightmap(b0: number, b1: number, b2: number, b3: number): this;
        abstract y(arg0: number): number;
        abstract copyPos(arg0: number, arg1: Vec3f_): Vec3f;
        /**
         * @deprecated
        */
        spriteU(vertexIndex: number, spriteIndex: number): number;
        abstract fromVanilla(arg0: Internal.BakedQuad_, arg1: Internal.RenderMaterial_, arg2: Internal.Direction_): this;
        /**
         * @deprecated
        */
        toVanilla(spriteIndex: number, target: number[], targetIndex: number, isItem: boolean): void;
        abstract lightmap(arg0: number, arg1: number): this;
        abstract material(): Internal.RenderMaterial;
        abstract toVanilla(arg0: number[], arg1: number): void;
        abstract faceNormal(): Vec3f;
        uv(vertexIndex: number, uv: Internal.Vector2f_): this;
        abstract posByIndex(arg0: number, arg1: number): number;
        abstract pos(arg0: number, arg1: number, arg2: number, arg3: number): this;
        abstract fromVanilla(arg0: number[], arg1: number): this;
        color(c0: number, c1: number, c2: number, c3: number): this;
        /**
         * @deprecated
        */
        spriteColor(spriteIndex: number, c0: number, c1: number, c2: number, c3: number): this;
        /**
         * @deprecated
        */
        sprite(vertexIndex: number, spriteIndex: number, u: number, v: number): this;
        /**
         * @deprecated
        */
        copyTo(target: Internal.MutableQuadView_): void;
        normal(vertexIndex: number, normal: Vec3f_): this;
        abstract normalY(arg0: number): number;
        readonly BAKE_ROTATE_270: 3;
        readonly BAKE_FLIP_V: 16;
        readonly BAKE_FLIP_U: 8;
        readonly BAKE_ROTATE_180: 2;
        readonly BAKE_ROTATE_90: 1;
        readonly BAKE_ROTATE_NONE: 0;
        readonly BAKE_LOCK_UV: 4;
        readonly BAKE_NORMALIZED: 32;
    }
    type MutableQuadView_ = MutableQuadView;
    class ChickenCatcherItem extends Internal.Item {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        static getTypeFromStack(stack: Internal.ItemStack_): string;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ChickenCatcherItem_ = ChickenCatcherItem;
    interface AbstractMinecartAccessor {
        abstract port_lib$getMaxSpeed(): number;
        (): number;
    }
    type AbstractMinecartAccessor_ = AbstractMinecartAccessor;
    abstract class ModalPanel extends Internal.Panel {
        constructor(panel: Internal.Panel_)
        closeGui(): void;
        setExtraZlevel(extraZlevel: number): void;
        openGui(): void;
        closeContextMenu(): void;
        closeGui(openPrevScreen: boolean): void;
        run(): void;
        openAfter(runnable: Internal.Runnable_): Internal.Runnable;
        getExtraZlevel(): number;
        openGuiLater(): void;
        set extraZlevel(extraZlevel: number)
        get extraZlevel(): number
    }
    type ModalPanel_ = ModalPanel;
    class SlimeFungusBlock extends Internal.FungusBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, fungusFeature: Internal.ResourceKey_<Internal.ConfiguredFeature<any, any>>)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getPlantType(world: Internal.BlockGetter_, pos: BlockPos_): Internal.PlantType;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type SlimeFungusBlock_ = SlimeFungusBlock;
    class ItemStackHandlerSlot extends Internal.SingleStackStorage {
        constructor(index: number, handler: io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler_, initial: Internal.ItemStack_)
        save(): Internal.CompoundTag;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        getSlot(slot: number): Internal.SingleSlotStorage<Internal.ItemVariant>;
        supportsInsertion(): boolean;
        getUnderlyingView(): Internal.StorageView<Internal.ItemVariant>;
        getIndex(): number;
        static asClass<T>(): Internal.Storage<T>;
        supportsExtraction(): boolean;
        setNewStack(stack: Internal.ItemStack_): void;
        getSlotCount(): number;
        load(tag: Internal.CompoundTag_): void;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.ItemVariant>>;
        static empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        get underlyingView(): Internal.StorageView<Internal.ItemVariant>
        get index(): number
        set newStack(stack: Internal.ItemStack_)
        get slotCount(): number
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>
        get version(): number
    }
    type ItemStackHandlerSlot_ = ItemStackHandlerSlot;
    class NixieTubeDisplayTarget extends Internal.SingleLineDisplayTarget {
        constructor()
    }
    type NixieTubeDisplayTarget_ = NixieTubeDisplayTarget;
    class ArmorItem$Type extends Internal.Enum<Internal.ArmorItem$Type> {
        getSlot(): Internal.EquipmentSlot;
        static valueOf($$0: string): Internal.ArmorItem$Type;
        getName(): string;
        static values(): Internal.ArmorItem$Type[];
        get slot(): Internal.EquipmentSlot
        get name(): string
        static readonly HELMET: Internal.ArmorItem$Type;
        static readonly LEGGINGS: Internal.ArmorItem$Type;
        static readonly BOOTS: Internal.ArmorItem$Type;
        static readonly CHESTPLATE: Internal.ArmorItem$Type;
    }
    type ArmorItem$Type_ = "leggings" | ArmorItem$Type | "chestplate" | "boots" | "helmet";
    interface CustomValidationLootProvider {
        abstract validate(arg0: Internal.Map_<ResourceLocation, Internal.LootTable>, arg1: Internal.ValidationContext_): void;
        (arg0: Internal.Map<ResourceLocation, Internal.LootTable>, arg1: Internal.ValidationContext): void;
    }
    type CustomValidationLootProvider_ = CustomValidationLootProvider;
    class RedstonePillarBlock extends Internal.RotatedPillarBlock {
        constructor(settings: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type RedstonePillarBlock_ = RedstonePillarBlock;
    class SimpleWeightedRandomList$Builder <E> {
        constructor()
        build(): Internal.SimpleWeightedRandomList<E>;
        add($$0: E, $$1: number): this;
    }
    type SimpleWeightedRandomList$Builder_<E> = SimpleWeightedRandomList$Builder<E>;
    abstract class AbstractObject2IntFunction <K> implements Internal.Object2IntFunction<K>, Internal.Serializable {
        put(arg0: K, arg1: number): number;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2IntFunction<T>;
        andThenFloat(arg0: Internal.Int2FloatFunction_): Internal.Object2FloatFunction<K>;
        andThenLong(arg0: Internal.Int2LongFunction_): Internal.Object2LongFunction<K>;
        /**
         * @deprecated
        */
        get(arg0: any): number;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2IntFunction<T>;
        defaultReturnValue(): number;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: any): any;
        removeInt(arg0: any): number;
        andThenObject<T>(arg0: Internal.Int2ObjectFunction_<T>): Internal.Object2ObjectFunction<K, T>;
        /**
         * @deprecated
        */
        andThen<T>(arg0: Internal.Function_<number, T>): Internal.Function<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2IntFunction;
        apply(arg0: K): number;
        andThenShort(arg0: Internal.Int2ShortFunction_): Internal.Object2ShortFunction<K>;
        containsKey(arg0: any): boolean;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2IntFunction;
        abstract getInt(arg0: any): number;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        andThenInt(arg0: Internal.Int2IntFunction_): Internal.Object2IntFunction<K>;
        /**
         * @deprecated
        */
        put(arg0: K, arg1: number): number;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2IntFunction;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: number): number;
        andThenDouble(arg0: Internal.Int2DoubleFunction_): Internal.Object2DoubleFunction<K>;
        applyAsInt(arg0: K): number;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2IntFunction;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2IntFunction;
        size(): number;
        defaultReturnValue(arg0: number): void;
        andThenReference<T>(arg0: Internal.Int2ReferenceFunction_<T>): Internal.Object2ReferenceFunction<K, T>;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2IntFunction;
        clear(): void;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, number>;
        andThenByte(arg0: Internal.Int2ByteFunction_): Internal.Object2ByteFunction<K>;
        andThenChar(arg0: Internal.Int2CharFunction_): Internal.Object2CharFunction<K>;
        /**
         * @deprecated
        */
        remove(arg0: any): any;
        getOrDefault(arg0: any, arg1: number): number;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2IntFunction;
        static identity<T>(): Internal.Function<T, T>;
    }
    type AbstractObject2IntFunction_<K> = AbstractObject2IntFunction<K>;
}
declare namespace it.unimi.dsi.fastutil.ints {
    interface IntConsumer extends Internal.Consumer<number>, Internal.IntConsumer {
        andThen(arg0: it.unimi.dsi.fastutil.ints.IntConsumer_): this;
        /**
         * @deprecated
        */
        accept(arg0: any): void;
        /**
         * @deprecated
        */
        andThen(arg0: Internal.Consumer_<number>): Internal.Consumer<number>;
        abstract accept(arg0: number): void;
        /**
         * @deprecated
        */
        accept(arg0: number): void;
        andThen(arg0: Internal.IntConsumer_): Internal.IntConsumer;
        (arg0: number): void;
    }
    type IntConsumer_ = IntConsumer;
}
declare namespace dev.emi.trinkets.api {
    class SlotType {
        constructor(group: string, name: string, order: number, amount: number, icon: ResourceLocation_, quickMovePredicates: Internal.Set_<ResourceLocation>, validatorPredicates: Internal.Set_<ResourceLocation>, tooltipPredicates: Internal.Set_<ResourceLocation>, dropRule: Internal.TrinketEnums$DropRule_)
        getGroup(): string;
        getIcon(): ResourceLocation;
        getTooltipPredicates(): Internal.Set<ResourceLocation>;
        getName(): string;
        static read(data: Internal.CompoundTag_): dev.emi.trinkets.api.SlotType;
        getValidatorPredicates(): Internal.Set<ResourceLocation>;
        getOrder(): number;
        getAmount(): number;
        getQuickMovePredicates(): Internal.Set<ResourceLocation>;
        write(data: Internal.CompoundTag_): void;
        getDropRule(): Internal.TrinketEnums$DropRule;
        getTranslation(): Internal.MutableComponent;
        get group(): string
        get icon(): ResourceLocation
        get tooltipPredicates(): Internal.Set<ResourceLocation>
        get name(): string
        get validatorPredicates(): Internal.Set<ResourceLocation>
        get order(): number
        get amount(): number
        get quickMovePredicates(): Internal.Set<ResourceLocation>
        get dropRule(): Internal.TrinketEnums$DropRule
        get translation(): Internal.MutableComponent
    }
    type SlotType_ = SlotType;
}
declare namespace dev.lambdaurora.lambdynlights.shadow.nightconfig.core.utils {
    interface WriterSupplier {
        abstract get(): Internal.Writer;
        (): Internal.Writer_;
    }
    type WriterSupplier_ = WriterSupplier;
}
declare namespace dan200.computercraft.shared.peripheral.redstone {
    class RedstoneRelayBlock extends Internal.HorizontalDirectionalBlock implements Internal.EntityBlock, Internal.IBundledRedstoneBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        getBundledRedstoneOutput(level: Internal.Level_, pos: BlockPos_, side: Internal.Direction_): number;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type RedstoneRelayBlock_ = RedstoneRelayBlock;
}
declare namespace slimeknights.mantle.recipe.ingredient {
    abstract class FluidIngredient {
        constructor()
        write(buffer: Internal.FriendlyByteBuf_): void;
        test(stack: Internal.FluidStack_): boolean;
        abstract getAmount(arg0: Internal.Fluid_): number;
        static deserialize(parent: Internal.JsonObject_, name: string): slimeknights.mantle.recipe.ingredient.FluidIngredient;
        static of(...ingredients: slimeknights.mantle.recipe.ingredient.FluidIngredient_[]): slimeknights.mantle.recipe.ingredient.FluidIngredient;
        abstract serialize(): Internal.JsonElement;
        getFluids(): Internal.List<Internal.FluidStack>;
        static of(fluid: Internal.TagKey_<Internal.Fluid>, amount: number): slimeknights.mantle.recipe.ingredient.FluidIngredient;
        static read(buffer: Internal.FriendlyByteBuf_): slimeknights.mantle.recipe.ingredient.FluidIngredient;
        abstract test(arg0: Internal.Fluid_): boolean;
        static of(fluid: Internal.Fluid_, amount: number): slimeknights.mantle.recipe.ingredient.FluidIngredient;
        static of(stack: Internal.FluidStack_): slimeknights.mantle.recipe.ingredient.FluidIngredient;
        static deserialize(json: Internal.JsonElement_, name: string): slimeknights.mantle.recipe.ingredient.FluidIngredient;
        get fluids(): Internal.List<Internal.FluidStack>
        static readonly EMPTY: Internal.FluidIngredient$Empty;
        static SERIALIZER: Internal.FluidIngredient$Serializer;
    }
    type FluidIngredient_ = FluidIngredient;
}
